/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;

public class LogicalNotSymbolicValue
implements SymbolicValue {
    private final SymbolicValue negatedValue;

    private LogicalNotSymbolicValue(SymbolicValue negatedValue) {
        Preconditions.checkArgument((negatedValue != null ? 1 : 0) != 0, (Object)"negatedValue should not be null");
        this.negatedValue = negatedValue;
    }

    public static SymbolicValue create(SymbolicValue negatedValue) {
        if (UnknownSymbolicValue.UNKNOWN.equals(negatedValue)) {
            return UnknownSymbolicValue.UNKNOWN;
        }
        return new LogicalNotSymbolicValue(negatedValue);
    }

    @Override
    public List<ProgramState> constrain(ProgramState state, Constraint constraint) {
        return this.negatedValue.constrain(state, constraint.not());
    }

    @Override
    public Constraint inherentConstraint() {
        Constraint negatedConstraint = this.negatedValue.inherentConstraint();
        return negatedConstraint == null ? null : negatedConstraint.not();
    }

    public String toString() {
        return "!" + this.negatedValue;
    }
}

