/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class ObjectLiteralTreeImpl
extends JavaScriptTree
implements ObjectLiteralTree,
TypableTree {
    private SyntaxToken openCurlyBrace;
    private final SeparatedList<Tree> properties;
    private SyntaxToken closeCurlyBrace;
    private TypeSet types = TypeSet.emptyTypeSet();

    public ObjectLiteralTreeImpl(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        this.properties = new SeparatedList(Collections.emptyList(), Collections.emptyList());
    }

    public ObjectLiteralTreeImpl(SeparatedList<Tree> properties) {
        this.properties = properties;
    }

    public ObjectLiteralTreeImpl complete(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        return this;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public SeparatedList<Tree> properties() {
        return this.properties;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OBJECT_LITERAL;
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    @Override
    public void add(Type type) {
        this.types.add(type);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openCurlyBrace), this.properties.elementsAndSeparators((Function<Tree, Tree>)Functions.identity()), (Iterator)Iterators.singletonIterator((Object)this.closeCurlyBrace));
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitObjectLiteral(this);
    }
}

