/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import java.util.Map;
import org.sonar.javascript.lexer.JavaScriptPunctuator;
import org.sonar.javascript.tree.TreeKinds;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.SymbolModelBuilder;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class SymbolVisitor
extends DoubleDispatchVisitor {
    private SymbolModelBuilder symbolModel;
    private Scope currentScope;
    private Map<Tree, Scope> treeScopeMap;

    public SymbolVisitor(Map<Tree, Scope> treeScopeMap) {
        this.treeScopeMap = treeScopeMap;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.symbolModel = (SymbolModelBuilder)((Object)this.getContext().getSymbolModel());
        this.currentScope = null;
        this.enterScope(tree);
        super.visitScript(tree);
        this.leaveScope();
    }

    @Override
    public void visitBlock(BlockTree tree) {
        if (this.isScopeAlreadyEntered(tree)) {
            super.visitBlock(tree);
        } else {
            this.enterScope(tree);
            super.visitBlock(tree);
            this.leaveScope();
        }
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.init());
        this.enterScope(tree);
        this.scan(tree.condition());
        this.scan(tree.update());
        this.scan(tree.statement());
        this.leaveScope();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan(tree.expression());
        this.enterScope(tree);
        this.scan(tree.cases());
        this.leaveScope();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterScope(tree);
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.enterScope(tree);
        super.visitCatchBlock(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterScope(tree);
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope(tree);
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.enterScope(tree);
        super.visitArrowFunction(tree);
        this.leaveScope();
    }

    @Override
    public void visitClass(ClassTree tree) {
        IdentifierTree classNameIdentifier = tree.name();
        if (classNameIdentifier != null) {
            if (tree.is(Tree.Kind.CLASS_DECLARATION)) {
                this.declareClassSymbol(classNameIdentifier, this.getFunctionScope());
                this.enterScope(tree);
            } else {
                this.enterScope(tree);
                this.declareClassSymbol(classNameIdentifier, this.currentScope);
            }
        } else {
            this.enterScope(tree);
        }
        super.visitClass(tree);
        this.leaveScope();
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().is(Tree.Kind.IDENTIFIER_REFERENCE)) {
            IdentifierTree identifier = (IdentifierTree)tree.variable();
            Usage.Kind usageKind = Usage.Kind.WRITE;
            if (!tree.operator().text().equals(JavaScriptPunctuator.EQU.getValue())) {
                usageKind = Usage.Kind.READ_WRITE;
            }
            if (!this.addUsageFor(identifier, usageKind)) {
                Symbol symbol = this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.symbolModel.globalScope());
                symbol.addUsage(Usage.create(identifier, usageKind));
            }
            this.scan(tree.expression());
        } else {
            super.visitAssignmentExpression(tree);
        }
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.THIS)) {
            this.addUsageFor(tree, Usage.Kind.READ);
        }
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (TreeKinds.isIncrementOrDecrement(tree) && tree.expression().is(Tree.Kind.IDENTIFIER_REFERENCE)) {
            this.addUsageFor((IdentifierTree)tree.expression(), Usage.Kind.READ_WRITE);
        } else {
            super.visitUnaryExpression(tree);
        }
    }

    @Override
    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.enterScope(tree);
        if (tree.variableOrExpression().is(Tree.Kind.IDENTIFIER_REFERENCE)) {
            IdentifierTree identifier = (IdentifierTree)tree.variableOrExpression();
            if (!this.addUsageFor(identifier, Usage.Kind.WRITE)) {
                this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.symbolModel.globalScope()).addUsage(Usage.create(identifier, Usage.Kind.WRITE));
            }
            this.scan(tree.expression());
            this.scan(tree.statement());
        } else {
            super.visitForObjectStatement(tree);
        }
        this.leaveScope();
    }

    private void leaveScope() {
        if (this.currentScope != null) {
            this.currentScope = this.currentScope.outer();
        }
    }

    private void enterScope(Tree tree) {
        this.currentScope = this.treeScopeMap.get(tree);
        if (this.currentScope == null) {
            throw new IllegalStateException("No scope found for the tree");
        }
    }

    private boolean addUsageFor(IdentifierTree identifier, Usage.Kind kind) {
        Symbol symbol = this.currentScope.lookupSymbol(identifier.name());
        if (symbol != null) {
            symbol.addUsage(Usage.create(identifier, kind));
            return true;
        }
        return false;
    }

    private boolean isScopeAlreadyEntered(BlockTree tree) {
        return !this.treeScopeMap.containsKey(tree);
    }

    private Scope getFunctionScope() {
        Scope scope = this.currentScope;
        while (scope.isBlock()) {
            scope = scope.outer();
        }
        return scope;
    }

    private void declareClassSymbol(IdentifierTree classNameIdentifier, Scope scope) {
        this.symbolModel.declareSymbol(classNameIdentifier.name(), Symbol.Kind.CLASS, scope).addUsage(Usage.create(classNameIdentifier, Usage.Kind.DECLARATION));
    }
}

