/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.javascript.tree.symbols.type.ObjectType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class ClassType
extends ObjectType {
    private Map<String, Symbol> properties = new HashMap<String, Symbol>();

    protected ClassType() {
        super(Type.Callability.NON_CALLABLE);
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.CLASS;
    }

    public static ClassType create() {
        return new ClassType();
    }

    public ObjectType createObject() {
        ObjectType objectType = ObjectType.create(Type.Callability.NON_CALLABLE);
        objectType.classType(this);
        return objectType;
    }

    public void addMethod(IdentifierTree name, FunctionType functionType) {
        Symbol symbol = new Symbol(name.name(), Symbol.Kind.METHOD, null);
        symbol.addUsage(Usage.create(name, Usage.Kind.DECLARATION));
        symbol.addType(functionType);
        this.properties.put(name.name(), symbol);
    }

    public Collection<Symbol> properties() {
        return this.properties.values();
    }

    @Override
    @Nullable
    public Symbol property(String name) {
        return this.properties.get(name);
    }
}

