/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.symbols;

import com.google.common.annotations.Beta;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

@Beta
public class Usage {
    private Kind kind;
    private IdentifierTree identifierTree;

    private Usage(IdentifierTree identifierTree, Kind kind) {
        this.kind = kind;
        this.identifierTree = identifierTree;
    }

    public Symbol symbol() {
        return this.identifierTree.symbol();
    }

    public Kind kind() {
        return this.kind;
    }

    public IdentifierTree identifierTree() {
        return this.identifierTree;
    }

    public static Usage create(IdentifierTree symbolTree, Kind kind) {
        return new Usage(symbolTree, kind);
    }

    public boolean isDeclaration() {
        return this.kind == Kind.DECLARATION_WRITE || this.kind == Kind.DECLARATION;
    }

    public boolean isWrite() {
        return this.kind == Kind.DECLARATION_WRITE || this.kind == Kind.WRITE || this.kind == Kind.READ_WRITE;
    }

    public static enum Kind {
        DECLARATION,
        DECLARATION_WRITE,
        LEXICAL_DECLARATION,
        WRITE,
        READ,
        READ_WRITE;

    }
}

