/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.javascript.metrics.CommentLineVisitor;
import org.sonar.javascript.metrics.CounterVisitor;
import org.sonar.javascript.metrics.LineVisitor;
import org.sonar.javascript.tree.visitors.SubscriptionTreeVisitor;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class MetricsVisitor
extends SubscriptionTreeVisitor {
    private static final Number[] LIMITS_COMPLEXITY_FUNCTIONS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private static final Tree.Kind[] FUNCTION_NODES = new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION};
    private static final Tree.Kind[] CLASS_NODES = new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION};
    private final FileSystem fs;
    private final SensorContext sensorContext;
    private InputFile inputFile;
    private NoSonarFilter noSonarFilter;
    private final Boolean ignoreHeaderComments;
    private FileLinesContextFactory fileLinesContextFactory;
    private int classComplexity;
    private int functionComplexity;
    private RangeDistributionBuilder functionComplexityDistribution;
    private RangeDistributionBuilder fileComplexityDistribution;

    public MetricsVisitor(FileSystem fs, SensorContext context, NoSonarFilter noSonarFilter, Boolean ignoreHeaderComments, FileLinesContextFactory fileLinesContextFactory) {
        this.fs = fs;
        this.sensorContext = context;
        this.noSonarFilter = noSonarFilter;
        this.ignoreHeaderComments = ignoreHeaderComments;
        this.fileLinesContextFactory = fileLinesContextFactory;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> result = new ArrayList<Tree.Kind>(Arrays.asList(FUNCTION_NODES));
        result.addAll(Arrays.asList(CLASS_NODES));
        return result;
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(CLASS_NODES)) {
            this.classComplexity += this.getContext().getComplexity(tree);
        } else if (tree.is(FUNCTION_NODES)) {
            int currentFunctionComplexity = this.getContext().getComplexity(tree);
            this.functionComplexity += currentFunctionComplexity;
            this.functionComplexityDistribution.add((Number)currentFunctionComplexity);
        }
    }

    @Override
    public void scanFile(TreeVisitorContext context) {
        this.inputFile = this.fs.inputFile(this.fs.predicates().is(context.getFile()));
        this.init();
        super.scanFile(context);
        this.saveComplexityMetrics(context);
        this.saveCounterMetrics(context);
        this.saveLineMetrics(context);
    }

    private void init() {
        this.classComplexity = 0;
        this.functionComplexity = 0;
        this.functionComplexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, LIMITS_COMPLEXITY_FUNCTIONS);
        this.fileComplexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
    }

    private void saveCounterMetrics(TreeVisitorContext context) {
        CounterVisitor counter = new CounterVisitor(context.getTopTree());
        this.saveMetricOnFile(CoreMetrics.FUNCTIONS, counter.getFunctionNumber());
        this.saveMetricOnFile(CoreMetrics.STATEMENTS, counter.getStatementsNumber());
        this.saveMetricOnFile(CoreMetrics.ACCESSORS, counter.getAccessorsNumber());
        this.saveMetricOnFile(CoreMetrics.CLASSES, counter.getClassNumber());
    }

    private void saveComplexityMetrics(TreeVisitorContext context) {
        int fileComplexity = context.getComplexity(context.getTopTree());
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY, fileComplexity);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY_IN_CLASSES, this.classComplexity);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY_IN_FUNCTIONS, this.functionComplexity);
        this.sensorContext.saveMeasure(this.inputFile, this.functionComplexityDistribution.build(true).setPersistenceMode(PersistenceMode.MEMORY));
        this.fileComplexityDistribution.add((Number)fileComplexity);
        this.sensorContext.saveMeasure(this.inputFile, this.fileComplexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveLineMetrics(TreeVisitorContext context) {
        LineVisitor lineVisitor = new LineVisitor(context.getTopTree());
        int linesNumber = lineVisitor.getLinesNumber();
        Set<Integer> linesOfCode = lineVisitor.getLinesOfCode();
        this.saveMetricOnFile(CoreMetrics.NCLOC, lineVisitor.getLinesOfCodeNumber());
        this.saveMetricOnFile(CoreMetrics.LINES, linesNumber);
        CommentLineVisitor commentVisitor = new CommentLineVisitor(context.getTopTree(), this.ignoreHeaderComments);
        Set<Integer> commentLines = commentVisitor.getCommentLines();
        this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, commentVisitor.getCommentLineNumber());
        this.noSonarFilter.addComponent(this.sensorContext.getResource((InputPath)this.inputFile).getEffectiveKey(), commentVisitor.noSonarLines());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(this.inputFile);
        for (int line = 1; line <= linesNumber; ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("comment_lines_data", line, commentLines.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
    }

    private void saveMetricOnFile(Metric metric, double value) {
        this.sensorContext.saveMeasure(this.inputFile, metric, Double.valueOf(value));
    }

    public static Tree.Kind[] getClassNodes() {
        return CLASS_NODES;
    }

    public static Tree.Kind[] getFunctionNodes() {
        return FUNCTION_NODES;
    }
}

