/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxTrivia;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class JavaScriptNodeBuilder
implements NodeBuilder {
    public Object createNonTerminal(GrammarRuleKey ruleKey, Rule rule, List<Object> children, int startIndex, int endIndex) {
        for (Object child : children) {
            if (!(child instanceof InternalSyntaxToken)) continue;
            return child;
        }
        return new InternalSyntaxSpacing();
    }

    public Object createTerminal(Input input, int startIndex, int endIndex, List<Trivia> trivias, TokenType type) {
        boolean isEof = GenericTokenType.EOF.equals((Object)type);
        LineColumnValue lineColumnValue = JavaScriptNodeBuilder.tokenPosition(input, startIndex, endIndex);
        return new InternalSyntaxToken(lineColumnValue.line, lineColumnValue.column, lineColumnValue.value, JavaScriptNodeBuilder.createTrivias(trivias), startIndex, isEof);
    }

    private static List<SyntaxTrivia> createTrivias(List<Trivia> trivias) {
        ArrayList result = Lists.newArrayList();
        for (Trivia trivia : trivias) {
            Token trivialToken = trivia.getToken();
            result.add(InternalSyntaxTrivia.create(trivialToken.getValue(), trivialToken.getLine(), trivialToken.getColumn()));
        }
        return result;
    }

    private static LineColumnValue tokenPosition(Input input, int startIndex, int endIndex) {
        int[] lineAndColumn = input.lineAndColumnAt(startIndex);
        String value = input.substring(startIndex, endIndex);
        return new LineColumnValue(lineAndColumn[0], lineAndColumn[1] - 1, value);
    }

    private static class InternalSyntaxSpacing
    extends JavaScriptTree {
        private InternalSyntaxSpacing() {
        }

        @Override
        public void accept(TreeVisitor visitor) {
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.TRIVIA;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    private static class LineColumnValue {
        final int line;
        final int column;
        final String value;

        private LineColumnValue(int line, int column, String value) {
            this.line = line;
            this.column = column;
            this.value = value;
        }
    }
}

