/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class ArrayLiteralTreeImpl
extends JavaScriptTree
implements ArrayLiteralTree {
    private SyntaxToken openBracket;
    private final SeparatedList<ExpressionTree> elements;
    private SyntaxToken closeBracket;
    private TypeSet types = TypeSet.emptyTypeSet();

    public ArrayLiteralTreeImpl(InternalSyntaxToken openBracket, InternalSyntaxToken closeBracket) {
        this.openBracket = openBracket;
        this.elements = new SeparatedList(ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST);
        this.closeBracket = closeBracket;
    }

    public ArrayLiteralTreeImpl(List<ExpressionTree> elements, List<InternalSyntaxToken> commas) {
        this.elements = new SeparatedList<ExpressionTree>(elements, commas);
    }

    public ArrayLiteralTreeImpl complete(InternalSyntaxToken openBracket, InternalSyntaxToken closeBracket) {
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
        return this;
    }

    @Override
    public SyntaxToken openBracket() {
        return this.openBracket;
    }

    @Override
    public SeparatedList<ExpressionTree> elements() {
        return this.elements;
    }

    @Override
    public SyntaxToken closeBracket() {
        return this.closeBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_LITERAL;
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    public void addType(Type type) {
        this.types.add(type);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.openBracket), this.elements.elementsAndSeparators((Function<ExpressionTree, Tree>)Functions.identity()), (Iterator)Iterators.singletonIterator((Object)this.closeBracket));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayLiteral(this);
    }
}

