/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BracketMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class BracketMemberExpressionTreeImpl
extends JavaScriptTree
implements BracketMemberExpressionTree {
    private ExpressionTree object;
    private final SyntaxToken openBracket;
    private final ExpressionTree property;
    private final SyntaxToken closeBracket;
    private TypeSet types = TypeSet.emptyTypeSet();

    public BracketMemberExpressionTreeImpl(InternalSyntaxToken openBracket, ExpressionTree property, InternalSyntaxToken closeBracket) {
        this.openBracket = openBracket;
        this.property = property;
        this.closeBracket = closeBracket;
    }

    public BracketMemberExpressionTreeImpl complete(ExpressionTree object) {
        this.object = object;
        return this;
    }

    @Override
    public ExpressionTree object() {
        return this.object;
    }

    @Override
    public SyntaxToken openBracket() {
        return this.openBracket;
    }

    @Override
    public ExpressionTree property() {
        return this.property;
    }

    @Override
    public void addType(Type type) {
        this.types.add(type);
    }

    @Override
    public SyntaxToken closeBracket() {
        return this.closeBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BRACKET_MEMBER_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.object, this.openBracket, this.property, this.closeBracket});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMemberExpression(this);
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }
}

