/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class CallExpressionTreeImpl
extends JavaScriptTree
implements CallExpressionTree {
    private final ExpressionTree callee;
    private final ParameterListTree arguments;
    private TypeSet types = TypeSet.emptyTypeSet();

    public CallExpressionTreeImpl(ExpressionTree callee, ParameterListTree arguments) {
        this.callee = callee;
        this.arguments = arguments;
    }

    @Override
    public ExpressionTree callee() {
        return this.callee;
    }

    @Override
    public ParameterListTree arguments() {
        return this.arguments;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CALL_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.callee, this.arguments});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCallExpression(this);
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    public void addType(Type type) {
        this.types.add(type);
    }
}

