/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class TemplateCharactersTreeImpl
extends JavaScriptTree
implements TemplateCharactersTree {
    private final String value;
    private final List<InternalSyntaxToken> characters;

    public TemplateCharactersTreeImpl(List<InternalSyntaxToken> characters) {
        this.characters = characters;
        StringBuilder builder = new StringBuilder();
        for (InternalSyntaxToken character : characters) {
            builder.append(character.text());
        }
        this.value = builder.toString();
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TEMPLATE_CHARACTERS;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Collections.unmodifiableList(this.characters).iterator();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTemplateCharacters(this);
    }

    @Override
    public TypeSet types() {
        return TypeSet.emptyTypeSet();
    }
}

