/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.config.Settings;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.SymbolModelBuilder;
import org.sonar.javascript.tree.symbols.SymbolVisitor;
import org.sonar.javascript.tree.symbols.type.TypeVisitor;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;

public class SymbolModelImpl
implements SymbolModel,
SymbolModelBuilder {
    private Map<Symbol, Scope> symbolScope = Maps.newHashMap();
    private Set<Scope> scopes = Sets.newHashSet();
    private Scope globalScope;

    public static SymbolModelImpl create(ScriptTree script, @Nullable Symbolizable symbolizable, @Nullable Settings settings) {
        SymbolModelImpl symbolModel = new SymbolModelImpl();
        new SymbolVisitor(symbolModel, symbolizable).visitScript(script);
        new TypeVisitor(settings).visitScript(script);
        return symbolModel;
    }

    private void setScopeForSymbol(Symbol symbol, Scope scope) {
        this.symbolScope.put(symbol, scope);
    }

    @Override
    public Scope globalScope() {
        return this.globalScope;
    }

    @Override
    public void addScope(Scope scope) {
        if (this.scopes.isEmpty()) {
            this.globalScope = scope;
        }
        this.scopes.add(scope);
    }

    @Override
    public Set<Scope> getScopes() {
        return this.scopes;
    }

    @Override
    public Symbol declareSymbol(String name, Symbol.Kind kind, Scope scope) {
        Symbol symbol = scope.getSymbol(name);
        if (symbol == null) {
            symbol = new Symbol(name, kind, scope);
            scope.addSymbol(symbol);
            this.setScopeForSymbol(symbol, scope);
        }
        return symbol;
    }

    @Override
    public Symbol declareBuiltInSymbol(String name, Symbol.Kind kind, Scope scope) {
        Symbol symbol = scope.getSymbol(name);
        if (symbol == null) {
            symbol = new Symbol(name, kind, scope);
            symbol.setBuiltIn(true);
            scope.addSymbol(symbol);
            this.setScopeForSymbol(symbol, scope);
        }
        return symbol;
    }

    @Override
    public Set<Symbol> getSymbols() {
        return this.symbolScope.keySet();
    }

    @Override
    public Set<Symbol> getSymbols(Symbol.Kind kind) {
        HashSet<Symbol> result = new HashSet<Symbol>();
        for (Symbol symbol : this.getSymbols()) {
            if (!kind.equals((Object)symbol.kind())) continue;
            result.add(symbol);
        }
        return result;
    }

    @Override
    public Set<Symbol> getSymbols(String name) {
        HashSet<Symbol> result = new HashSet<Symbol>();
        for (Symbol symbol : this.getSymbols()) {
            if (!name.equals(symbol.name())) continue;
            result.add(symbol);
        }
        return result;
    }

    @Override
    @Nullable
    public Scope getScope(Tree tree) {
        for (Scope scope : this.getScopes()) {
            if (!scope.tree().equals(tree)) continue;
            return scope;
        }
        return null;
    }
}

