/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.highlighter.HighlightSymbolTableBuilder;
import org.sonar.javascript.lexer.JavaScriptPunctuator;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.javascript.tree.symbols.SymbolDeclarationVisitor;
import org.sonar.javascript.tree.symbols.SymbolModelBuilder;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.GeneratorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ForInStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForOfStatementTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;

public class SymbolVisitor
extends BaseTreeVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolVisitor.class);
    private final Symbolizable symbolizable;
    private SymbolModelBuilder symbolModel;
    private Scope currentScope;

    public SymbolVisitor(SymbolModelBuilder symbolModel, @Nullable Symbolizable symbolizable) {
        this.symbolModel = symbolModel;
        this.currentScope = null;
        this.symbolizable = symbolizable;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        new SymbolDeclarationVisitor(this.symbolModel).visitScript(tree);
        this.enterScope(tree);
        super.visitScript(tree);
        this.leaveScope();
        this.highlightSymbols();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterScope(tree);
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.enterScope(tree);
        super.visitAccessorMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitGeneratorMethodDeclaration(GeneratorMethodDeclarationTree tree) {
        this.enterScope(tree);
        super.visitGeneratorMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.enterScope(tree);
        super.visitCatchBlock(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterScope(tree);
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope(tree);
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.enterScope(tree);
        super.visitArrowFunction(tree);
        this.leaveScope();
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable() instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree.variable();
            Usage.Kind usageKind = Usage.Kind.WRITE;
            if (!tree.operator().text().equals(JavaScriptPunctuator.EQU.getValue())) {
                usageKind = Usage.Kind.READ_WRITE;
            }
            if (!this.addUsageFor(identifier, usageKind)) {
                Symbol symbol = this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.symbolModel.globalScope());
                symbol.addUsage(Usage.create(identifier, usageKind));
            }
            this.scan(tree.expression());
        } else {
            super.visitAssignmentExpression(tree);
        }
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER_REFERENCE)) {
            this.addUsageFor(tree, Usage.Kind.READ);
        }
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (SymbolVisitor.isIncDec(tree) && tree.expression().is(Tree.Kind.IDENTIFIER_REFERENCE)) {
            this.addUsageFor((IdentifierTree)tree.expression(), Usage.Kind.READ_WRITE);
        } else {
            super.visitUnaryExpression(tree);
        }
    }

    private static boolean isIncDec(UnaryExpressionTree tree) {
        return tree.is(Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT);
    }

    @Override
    public void visitForOfStatement(ForOfStatementTree tree) {
        IdentifierTree identifier;
        if (tree.variableOrExpression() instanceof IdentifierTree && !this.addUsageFor(identifier = (IdentifierTree)tree.variableOrExpression(), Usage.Kind.WRITE)) {
            this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.symbolModel.globalScope()).addUsage(Usage.create(identifier, Usage.Kind.WRITE));
        }
        super.visitForOfStatement(tree);
    }

    @Override
    public void visitForInStatement(ForInStatementTree tree) {
        if (tree.variableOrExpression() instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree.variableOrExpression();
            if (!this.addUsageFor(identifier, Usage.Kind.WRITE)) {
                this.symbolModel.declareSymbol(identifier.name(), Symbol.Kind.VARIABLE, this.symbolModel.globalScope()).addUsage(Usage.create(identifier, Usage.Kind.WRITE));
            }
            this.scan(tree.expression());
            this.scan(tree.statement());
        } else {
            super.visitForInStatement(tree);
        }
    }

    private void leaveScope() {
        if (this.currentScope != null) {
            this.currentScope = this.currentScope.outer();
        }
    }

    private void enterScope(Tree tree) {
        this.currentScope = this.getScopeFor(tree);
    }

    private boolean addUsageFor(IdentifierTree identifier, Usage.Kind kind) {
        Symbol symbol = this.currentScope.lookupSymbol(identifier.name());
        if (symbol != null) {
            symbol.addUsage(Usage.create(identifier, kind));
            return true;
        }
        return false;
    }

    private void highlightSymbols() {
        if (this.symbolizable != null) {
            this.symbolizable.setSymbolTable(HighlightSymbolTableBuilder.build(this.symbolizable, (SymbolModel)((Object)this.symbolModel)));
        } else {
            LOG.warn("Symbol in source view will not be highlighted.");
        }
    }

    private Scope getScopeFor(Tree tree) {
        for (Scope scope : this.symbolModel.getScopes()) {
            if (!scope.tree().equals(tree)) continue;
            return scope;
        }
        throw new IllegalStateException("No scope found for the tree");
    }
}

