/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.api.visitors;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.sonar.sslr.api.typed.Optional;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.expression.SuperTreeImpl;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ArrayBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingPropertyTree;
import org.sonar.plugins.javascript.api.tree.declaration.DefaultExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ExportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.FromClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.GeneratorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportModuleDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NameSpaceExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NamedExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ObjectBindingPatternTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierListTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.ComputedPropertyNameTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.RestElementTree;
import org.sonar.plugins.javascript.api.tree.expression.TaggedTemplateTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateCharactersTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ThisTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DebuggerStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.EmptyStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForInStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForOfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.LabelledStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WithStatementTree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

@Beta
public class BaseTreeVisitor
implements TreeVisitor,
JavaScriptCheck {
    private TreeVisitorContext context = null;

    @Override
    public TreeVisitorContext getContext() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"this#scanFile(context) should be called to initialised the context before accessing it");
        return this.context;
    }

    @Override
    public void scanFile(TreeVisitorContext context) {
        this.context = context;
        this.scan(context.getTopTree());
    }

    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    protected <T> void scan(List<T> trees) {
        for (T tree : trees) {
            if (tree instanceof Optional) {
                this.scan((Optional<Tree>)((Optional)tree));
                continue;
            }
            if (tree instanceof Tree) {
                this.scan((Tree)tree);
                continue;
            }
            throw new IllegalArgumentException("List element type should be of type Optional or Tree.");
        }
    }

    private void scan(Optional<Tree> tree) {
        if (tree.isPresent()) {
            this.scan((Tree)tree.get());
        }
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.scan(tree.items());
    }

    @Override
    public void visitModule(ModuleTree tree) {
        this.scan(tree.items());
    }

    @Override
    public void visitImportDeclaration(ImportDeclarationTree tree) {
        this.scan(tree.importClause());
        this.scan(tree.fromClause());
    }

    @Override
    public void visitImportModuleDeclaration(ImportModuleDeclarationTree tree) {
        this.scan(tree.moduleName());
    }

    @Override
    public void visitImportClause(ImportClauseTree tree) {
        this.scan(tree.namedImport());
    }

    @Override
    public void visitSpecifierList(SpecifierListTree tree) {
        this.scan(tree.specifiers());
    }

    @Override
    public void visitSpecifier(SpecifierTree tree) {
        this.scan(tree.name());
        this.scan(tree.localName());
    }

    @Override
    public void visitFromClause(FromClauseTree tree) {
        this.scan(tree.module());
    }

    @Override
    public void visitDefaultExportDeclaration(DefaultExportDeclarationTree tree) {
        this.scan(tree.object());
    }

    @Override
    public void visitNameSpaceExportDeclaration(NameSpaceExportDeclarationTree tree) {
        this.scan(tree.fromClause());
    }

    @Override
    public void visitNamedExportDeclaration(NamedExportDeclarationTree tree) {
        this.scan(tree.object());
    }

    @Override
    public void visitVariableStatement(VariableStatementTree tree) {
        this.scan(tree.declaration());
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.scan(tree.variables());
    }

    @Override
    public void visitClassDeclaration(ClassTree tree) {
        this.scan(tree.name());
        this.scan(tree.superClass());
        this.scan(tree.elements());
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }

    @Override
    public void visitParameterList(ParameterListTree tree) {
        this.scan(tree.parameters());
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitEmptyStatement(EmptyStatementTree tree) {
    }

    @Override
    public void visitLabelledStatement(LabelledStatementTree tree) {
        this.scan(tree.label());
        this.scan(tree.statement());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statement());
        this.scan(tree.elseClause());
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.init());
        this.scan(tree.condition());
        this.scan(tree.update());
        this.scan(tree.statement());
    }

    @Override
    public void visitForInStatement(ForInStatementTree tree) {
        this.scan(tree.variableOrExpression());
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    @Override
    public void visitForOfStatement(ForOfStatementTree tree) {
        this.scan(tree.variableOrExpression());
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statement());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.scan(tree.statement());
        this.scan(tree.condition());
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.scan(tree.label());
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.scan(tree.label());
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitWithStatement(WithStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.cases());
    }

    @Override
    public void visitDefaultClause(DefaultClauseTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitCaseClause(CaseClauseTree tree) {
        this.scan(tree.expression());
        this.scan(tree.statements());
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.block());
        this.scan(tree.catchBlock());
        this.scan(tree.finallyBlock());
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.scan(tree.parameter());
        this.scan(tree.block());
    }

    @Override
    public void visitDebugger(DebuggerStatementTree tree) {
    }

    @Override
    public void visitArrayBindingPattern(ArrayBindingPatternTree tree) {
        this.scan(tree.elements());
    }

    @Override
    public void visitObjectBindingPattern(ObjectBindingPatternTree tree) {
        this.scan(tree.elements());
    }

    @Override
    public void visitObjectLiteral(ObjectLiteralTree tree) {
        this.scan(tree.properties());
    }

    @Override
    public void visitBindingProperty(BindingPropertyTree tree) {
        this.scan(tree.name());
        this.scan(tree.value());
    }

    @Override
    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        this.scan(tree.left());
        this.scan(tree.right());
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
    }

    @Override
    public void visitArrayLiteral(ArrayLiteralTree tree) {
        this.scan(tree.elements());
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.scan(tree.variable());
        this.scan(tree.expression());
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.scan(tree.condition());
        this.scan(tree.trueExpression());
        this.scan(tree.falseExpression());
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.scan(tree.parameters());
        this.scan(tree.conciseBody());
    }

    @Override
    public void visitYieldExpression(YieldExpressionTree tree) {
        this.scan(tree.argument());
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.scan(tree.leftOperand());
        this.scan(tree.rightOperand());
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitMemberExpression(MemberExpressionTree tree) {
        this.scan(tree.object());
        this.scan(tree.property());
    }

    @Override
    public void visitTaggedTemplate(TaggedTemplateTree tree) {
        this.scan(tree.callee());
        this.scan(tree.template());
    }

    @Override
    public void visitCallExpression(CallExpressionTree tree) {
        this.scan(tree.callee());
        this.scan(tree.arguments());
    }

    @Override
    public void visitTemplateLiteral(TemplateLiteralTree tree) {
        this.scan(tree.strings());
        this.scan(tree.expressions());
    }

    @Override
    public void visitTemplateExpression(TemplateExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitTemplateCharacters(TemplateCharactersTree tree) {
    }

    @Override
    public void visitParenthesisedExpression(ParenthesisedExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitComputedPropertyName(ComputedPropertyNameTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitPairProperty(PairPropertyTree tree) {
        this.scan(tree.key());
        this.scan(tree.value());
    }

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        this.scan(tree.expression());
        this.scan(tree.arguments());
    }

    @Override
    public void visitThisTree(ThisTree tree) {
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }

    @Override
    public void visitRestElement(RestElementTree tree) {
        this.scan(tree.element());
    }

    @Override
    public void visitSuper(SuperTreeImpl tree) {
    }

    @Override
    public void visitExportClause(ExportClauseTree tree) {
        this.scan(tree.exports());
        this.scan(tree.fromClause());
    }

    @Override
    public void visitAccessorMethodDeclaration(AccessorMethodDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }

    @Override
    public void visitGeneratorMethodDeclaration(GeneratorMethodDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }
}

