/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import java.nio.charset.Charset;
import org.sonar.javascript.lexer.JavaScriptKeyword;
import org.sonar.javascript.lexer.JavaScriptPunctuator;
import org.sonar.javascript.lexer.JavaScriptRegexpChannel;
import org.sonar.javascript.lexer.JavaScriptTokenType;
import org.sonar.sslr.channel.Channel;

public final class JavaScriptLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP = "([Pp][+-]?+[0-9_]++)";
    private static final String FLOAT_SUFFIX = "[fFdD]";
    private static final String INT_SUFFIX = "[lL]";
    public static final String NUMERIC_LITERAL = "(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)";
    public static final String LITERAL = "(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')";
    public static final String SINGLE_LINE_COMMENT = "//[^\\n\\r]*+|<!--[^\\n\\r]*+";
    public static final String MULTI_LINE_COMMENT = "/\\*[\\s\\S]*?\\*/";
    public static final String MULTI_LINE_COMMENT_NO_LB = "/\\*[^\\n\\r]*?\\*/";
    public static final String COMMENT = "(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)";
    private static final String HEX_DIGIT = "[0-9a-fA-F]";
    private static final String UNICODE_ESCAPE_SEQUENCE = "u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]";
    private static final String UNICODE_LETTER = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}";
    private static final String UNICODE_COMBINING_MARK = "\\p{Mn}\\p{Mc}";
    private static final String UNICODE_DIGIT = "\\p{Nd}";
    private static final String UNICODE_CONNECTOR_PUNCTUATION = "\\p{Pc}";
    private static final String IDENTIFIER_START = "(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])";
    private static final String IDENTIFIER_PART = "(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])";
    public static final String IDENTIFIER = "(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+";
    public static final String LINE_TERMINATOR = "\\n\\r\\u2028\\u2029";
    public static final String LINE_TERMINATOR_SEQUENCE = "(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)";
    public static final String WHITESPACE = "\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}";

    private JavaScriptLexer() {
    }

    public static Lexer create(Charset charset) {
        return Lexer.builder().withCharset(charset).withFailIfNoChannelToConsumeOneCharacter(true).withChannel((Channel)new BlackHoleChannel("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{COMMENT})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.LITERAL, (String[])new String[]{LITERAL})).withChannel((Channel)new JavaScriptRegexpChannel()).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)JavaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{NUMERIC_LITERAL})).withChannel((Channel)new IdentifierAndKeywordChannel(IDENTIFIER, true, (TokenType[][])new TokenType[][]{JavaScriptKeyword.values()})).withChannel((Channel)new PunctuatorChannel((TokenType[])JavaScriptPunctuator.values())).withChannel((Channel)new UnknownCharacterChannel()).build();
    }
}

