/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols.type;

import org.sonar.plugins.javascript.api.symbols.Type;

public class ObjectType
implements Type {
    protected Type.Callability callability;

    protected ObjectType(Type.Callability callability) {
        this.callability = callability;
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.OBJECT;
    }

    @Override
    public Type.Callability callability() {
        return this.callability;
    }

    public static ObjectType create() {
        return ObjectType.create(Type.Callability.UNKNOWN);
    }

    public static ObjectType create(Type.Callability callability) {
        return new ObjectType(callability);
    }

    public String toString() {
        return this.kind().name();
    }

    public static enum WebApiType implements Type
    {
        WINDOW{

            @Override
            public Type.Kind kind() {
                return Type.Kind.WINDOW;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        DOCUMENT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.DOCUMENT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        DOM_ELEMENT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.DOM_ELEMENT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        };

    }

    public static enum BuiltInObjectType implements Type
    {
        NUMBER{

            @Override
            public Type.Kind kind() {
                return Type.Kind.NUMBER_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        STRING{

            @Override
            public Type.Kind kind() {
                return Type.Kind.STRING_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        BOOLEAN{

            @Override
            public Type.Kind kind() {
                return Type.Kind.BOOLEAN_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        DATE{

            @Override
            public Type.Kind kind() {
                return Type.Kind.DATE;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        };

    }

    public static enum FrameworkType implements Type
    {
        JQUERY_SELECTOR_OBJECT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.JQUERY_SELECTOR_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.NON_CALLABLE;
            }
        }
        ,
        JQUERY_OBJECT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.JQUERY_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.CALLABLE;
            }
        }
        ,
        BACKBONE_MODEL{

            @Override
            public Type.Kind kind() {
                return Type.Kind.BACKBONE_MODEL;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.CALLABLE;
            }
        }
        ,
        BACKBONE_MODEL_OBJECT{

            @Override
            public Type.Kind kind() {
                return Type.Kind.BACKBONE_MODEL_OBJECT;
            }

            @Override
            public Type.Callability callability() {
                return Type.Callability.UNKNOWN;
            }
        };

    }
}

