/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.visitors;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public abstract class SubscriptionTreeVisitor
implements JavaScriptCheck {
    private TreeVisitorContext context;
    private Collection<Tree.Kind> nodesToVisit;

    public abstract List<Tree.Kind> nodesToVisit();

    @Override
    public TreeVisitorContext getContext() {
        return this.context;
    }

    public void visitNode(Tree tree) {
    }

    public void leaveNode(Tree tree) {
    }

    public void visitToken(SyntaxToken syntaxToken) {
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
    }

    public void visitFile(Tree scriptTree) {
    }

    @Override
    public void scanFile(TreeVisitorContext context) {
        this.context = context;
        this.visitFile(context.getTopTree());
        this.scanTree(context.getTopTree());
    }

    public void scanTree(Tree tree) {
        this.nodesToVisit = this.nodesToVisit();
        this.visit(tree);
    }

    private void visit(Tree tree) {
        boolean isSubscribed = this.isSubscribed(tree);
        if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (isSubscribed) {
            this.leaveNode(tree);
        }
    }

    protected boolean isSubscribed(Tree tree) {
        return this.nodesToVisit.contains((Object)((JavaScriptTree)tree).getKind());
    }

    private void visitChildren(Tree tree) {
        JavaScriptTree javaTree = (JavaScriptTree)tree;
        if (!javaTree.isLeaf()) {
            Iterator<Tree> iter = javaTree.childrenIterator();
            while (iter.hasNext()) {
                Tree next = iter.next();
                if (next == null) continue;
                this.visit(next);
            }
        }
    }
}

