/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.javascript.se.SeCheck;
import org.sonar.plugins.javascript.api.CustomJavaScriptRulesDefinition;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.visitors.TreeVisitor;

public class JavaScriptChecks {
    private final CheckFactory checkFactory;
    private Set<Checks<JavaScriptCheck>> checksByRepository = Sets.newHashSet();

    private JavaScriptChecks(CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
    }

    public static JavaScriptChecks createJavaScriptCheck(CheckFactory checkFactory) {
        return new JavaScriptChecks(checkFactory);
    }

    public JavaScriptChecks addChecks(String repositoryKey, List<Class> checkClass) {
        this.checksByRepository.add((Checks<JavaScriptCheck>)this.checkFactory.create(repositoryKey).addAnnotatedChecks(checkClass));
        return this;
    }

    public JavaScriptChecks addCustomChecks(@Nullable CustomJavaScriptRulesDefinition[] customRulesDefinitions) {
        if (customRulesDefinitions != null) {
            for (CustomJavaScriptRulesDefinition rulesDefinition : customRulesDefinitions) {
                this.addChecks(rulesDefinition.repositoryKey(), Lists.newArrayList((Object[])rulesDefinition.checkClasses()));
            }
        }
        return this;
    }

    private List<JavaScriptCheck> all() {
        ArrayList allVisitors = Lists.newArrayList();
        for (Checks<JavaScriptCheck> checks : this.checksByRepository) {
            allVisitors.addAll(checks.all());
        }
        return allVisitors;
    }

    public List<SeCheck> seChecks() {
        ArrayList<SeCheck> checks = new ArrayList<SeCheck>();
        for (JavaScriptCheck check : this.all()) {
            if (!(check instanceof SeCheck)) continue;
            checks.add((SeCheck)check);
        }
        return checks;
    }

    public List<TreeVisitor> visitorChecks() {
        ArrayList<TreeVisitor> checks = new ArrayList<TreeVisitor>();
        for (JavaScriptCheck check : this.all()) {
            if (!(check instanceof TreeVisitor)) continue;
            checks.add((TreeVisitor)check);
        }
        return checks;
    }

    @Nullable
    public RuleKey ruleKeyFor(JavaScriptCheck check) {
        for (Checks<JavaScriptCheck> checks : this.checksByRepository) {
            RuleKey ruleKey = checks.ruleKey((Object)check);
            if (ruleKey == null) continue;
            return ruleKey;
        }
        return null;
    }
}

