/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.CoverageMeasuresBuilder;

public final class LCOVParser {
    private static final String SF = "SF:";
    private static final String DA = "DA:";
    private static final String BRDA = "BRDA:";
    private final Map<InputFile, CoverageMeasuresBuilder> coverageByFile;
    private final FileSystem fs;
    private final List<String> unresolvedPaths = Lists.newArrayList();
    private static final Logger LOG = LoggerFactory.getLogger(LCOVParser.class);

    private LCOVParser(FileSystem fs, List<String> lines) {
        this.fs = fs;
        this.coverageByFile = this.parse(lines);
    }

    public static Map<InputFile, CoverageMeasuresBuilder> parse(FileSystem fs, List<String> lines) {
        return new LCOVParser(fs, lines).coverageByFile();
    }

    public static LCOVParser create(FileSystem fs, File ... files) {
        LinkedList<String> lines = new LinkedList<String>();
        for (File file : files) {
            try {
                lines.addAll(FileUtils.readLines((File)file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read content from file: " + file, e);
            }
        }
        return new LCOVParser(fs, lines);
    }

    public Map<InputFile, CoverageMeasuresBuilder> coverageByFile() {
        return this.coverageByFile;
    }

    public List<String> unresolvedPaths() {
        return this.unresolvedPaths;
    }

    private Map<InputFile, CoverageMeasuresBuilder> parse(List<String> lines) {
        HashMap files = Maps.newHashMap();
        FileData fileData = null;
        for (String line : lines) {
            if (line.startsWith(SF)) {
                fileData = this.loadCurrentFileData(files, line);
                continue;
            }
            if (fileData == null) continue;
            if (line.startsWith(DA)) {
                String execution = line.substring(DA.length());
                String executionCount = execution.substring(execution.indexOf(44) + 1);
                String lineNumber = execution.substring(0, execution.indexOf(44));
                try {
                    fileData.addLine(Integer.valueOf(lineNumber), Integer.valueOf(executionCount));
                }
                catch (IllegalArgumentException e) {
                    LCOVParser.logWrongDataWarning("DA", lineNumber, e);
                }
                continue;
            }
            if (!line.startsWith(BRDA)) continue;
            String[] tokens = line.substring(BRDA.length()).trim().split(",");
            String lineNumber = tokens[0];
            String branchNumber = tokens[1] + tokens[2];
            String taken = tokens[3];
            try {
                fileData.addBranch(Integer.valueOf(lineNumber), branchNumber, "-".equals(taken) ? 0 : Integer.valueOf(taken));
            }
            catch (IllegalArgumentException e) {
                LCOVParser.logWrongDataWarning("BRDA", lineNumber, e);
            }
        }
        HashMap coveredFiles = Maps.newHashMap();
        for (Map.Entry e : files.entrySet()) {
            coveredFiles.put(e.getKey(), ((FileData)e.getValue()).convert());
        }
        return coveredFiles;
    }

    private static void logWrongDataWarning(String dataType, String lineNumber, IllegalArgumentException e) {
        LOG.warn(String.format("Problem during processing LCOV report: can't save %s data for line %s.", dataType, lineNumber), (Throwable)e);
    }

    @CheckForNull
    private FileData loadCurrentFileData(Map<InputFile, FileData> files, String line) {
        String filePath = line.substring(SF.length());
        FileData fileData = null;
        InputFile inputFile = this.fs.inputFile(this.fs.predicates().hasPath(filePath));
        if (inputFile != null) {
            fileData = files.get(inputFile);
            if (fileData == null) {
                fileData = new FileData(inputFile);
                files.put(inputFile, fileData);
            }
        } else {
            this.unresolvedPaths.add(filePath);
        }
        return fileData;
    }

    private static class FileData {
        private Map<Integer, Map<String, Integer>> branches = Maps.newHashMap();
        private Map<Integer, Integer> hits = Maps.newHashMap();
        private final int linesInFile;
        private final String filename;
        private static final String WRONG_LINE_EXCEPTION_MESSAGE = "Line with number %s doesn't belong to file %s";

        public FileData(InputFile inputFile) {
            this.linesInFile = inputFile.lines();
            this.filename = inputFile.relativePath();
        }

        public void addBranch(Integer lineNumber, String branchNumber, Integer taken) {
            this.checkLine(lineNumber);
            HashMap branchesForLine = this.branches.get(lineNumber);
            if (branchesForLine == null) {
                branchesForLine = Maps.newHashMap();
                this.branches.put(lineNumber, branchesForLine);
            }
            Integer currentValue = (Integer)branchesForLine.get(branchNumber);
            branchesForLine.put(branchNumber, (Integer)Objects.firstNonNull((Object)currentValue, (Object)0) + taken);
        }

        public void addLine(Integer lineNumber, Integer executionCount) {
            this.checkLine(lineNumber);
            Integer currentValue = this.hits.get(lineNumber);
            this.hits.put(lineNumber, (Integer)Objects.firstNonNull((Object)currentValue, (Object)0) + executionCount);
        }

        public CoverageMeasuresBuilder convert() {
            CoverageMeasuresBuilder result = CoverageMeasuresBuilder.create();
            for (Map.Entry<Integer, Integer> entry : this.hits.entrySet()) {
                result.setHits(entry.getKey().intValue(), entry.getValue().intValue());
            }
            for (Map.Entry<Integer, Object> entry : this.branches.entrySet()) {
                int conditions = ((Map)entry.getValue()).size();
                int covered = 0;
                for (Integer taken : ((Map)entry.getValue()).values()) {
                    if (taken <= 0) continue;
                    ++covered;
                }
                result.setConditions(entry.getKey().intValue(), conditions, covered);
            }
            return result;
        }

        private void checkLine(Integer lineNumber) {
            if (lineNumber < 1 || lineNumber > this.linesInFile) {
                throw new IllegalArgumentException(String.format(WRONG_LINE_EXCEPTION_MESSAGE, lineNumber, this.filename));
            }
        }
    }
}

