/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.rule.RuleKey;
import org.sonar.javascript.issues.PreciseIssue;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.JavaScriptChecks;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class JavaScriptCheckContext
implements TreeVisitorContext {
    private static final boolean IS_SONARQUBE_52_OR_LATER = JavaScriptCheckContext.isSonarQube52OrLater();
    private final SensorContext sensorContext;
    private final ScriptTree tree;
    private final InputFile inputFile;
    private final SymbolModel symbolModel;
    private final Settings settings;
    private final ComplexityVisitor complexity;
    private final Issuable issuable;
    private final JavaScriptChecks checks;

    public JavaScriptCheckContext(SensorContext sensorContext, ScriptTree tree, Issuable issuable, InputFile inputFile, SymbolModel symbolModel, Settings settings, JavaScriptChecks checks, ComplexityVisitor complexityVisitor) {
        this.sensorContext = sensorContext;
        this.tree = tree;
        this.inputFile = inputFile;
        this.symbolModel = symbolModel;
        this.settings = settings;
        this.complexity = complexityVisitor;
        this.issuable = issuable;
        this.checks = checks;
    }

    public ScriptTree getTopTree() {
        return this.tree;
    }

    public void addIssue(JavaScriptCheck check, Tree tree, String message) {
        this.commonAddIssue(check, JavaScriptCheckContext.getLine(tree), message, -1.0);
    }

    public void addIssue(JavaScriptCheck check, int line, String message) {
        this.commonAddIssue(check, line, message, -1.0);
    }

    public void addFileIssue(JavaScriptCheck check, String message) {
        this.commonAddIssue(check, -1, message, -1.0);
    }

    public void addIssue(JavaScriptCheck check, Tree tree, String message, double cost) {
        this.commonAddIssue(check, JavaScriptCheckContext.getLine(tree), message, cost);
    }

    public void addIssue(JavaScriptCheck check, int line, String message, double cost) {
        this.commonAddIssue(check, line, message, cost);
    }

    public void addIssue(JavaScriptCheck check, IssueLocation location, List<IssueLocation> secondaryLocations, Double cost) {
        if (IS_SONARQUBE_52_OR_LATER) {
            RuleKey ruleKey = this.ruleKey(check);
            PreciseIssue.save((SensorContext)this.sensorContext, (InputFile)this.inputFile, (RuleKey)ruleKey, (IssueLocation)location, secondaryLocations, (Double)cost);
        } else {
            this.commonAddIssue(check, location.startLine(), location.message(), cost == null ? -1.0 : cost);
        }
    }

    public File getFile() {
        return this.inputFile.file();
    }

    private void commonAddIssue(JavaScriptCheck check, int line, String message, double cost) {
        Preconditions.checkNotNull((Object)message);
        RuleKey ruleKey = this.ruleKey(check);
        Issuable.IssueBuilder issueBuilder = this.issuable.newIssueBuilder().ruleKey(ruleKey).message(message);
        if (line > 0) {
            issueBuilder.line(Integer.valueOf(line));
        }
        if (cost > 0.0) {
            issueBuilder.effortToFix(Double.valueOf(cost));
        }
        this.issuable.addIssue(issueBuilder.build());
    }

    private RuleKey ruleKey(JavaScriptCheck check) {
        Preconditions.checkNotNull((Object)check);
        RuleKey ruleKey = this.checks.ruleKeyFor(check);
        if (ruleKey == null) {
            throw new IllegalStateException("No rule key found for a rule");
        }
        return ruleKey;
    }

    private static int getLine(Tree tree) {
        return ((JavaScriptTree)tree).getLine();
    }

    public SymbolModel getSymbolModel() {
        return this.symbolModel;
    }

    public String[] getPropertyValues(String name) {
        return this.settings.getStringArray(name);
    }

    public int getComplexity(Tree tree) {
        return this.complexity.getComplexity(tree);
    }

    private static boolean isSonarQube52OrLater() {
        for (Method method : Issuable.IssueBuilder.class.getMethods()) {
            if (!"newLocation".equals(method.getName())) continue;
            return true;
        }
        return false;
    }
}

