/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.component.Perspective;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.checks.CheckList;
import org.sonar.javascript.checks.ParsingErrorCheck;
import org.sonar.javascript.highlighter.HighlighterVisitor;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.metrics.MetricsVisitor;
import org.sonar.javascript.parser.JavaScriptParserBuilder;
import org.sonar.javascript.tree.symbols.SymbolModelImpl;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.JavaScriptCheckContext;
import org.sonar.plugins.javascript.JavaScriptChecks;
import org.sonar.plugins.javascript.api.CustomJavaScriptRulesDefinition;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.api.AnalysisException;

public class JavaScriptSquidSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptSquidSensor.class);
    private final JavaScriptChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final FileSystem fileSystem;
    private final NoSonarFilter noSonarFilter;
    private final FilePredicate mainFilePredicate;
    private final Settings settings;
    private final ActionParser<Tree> parser;
    private RuleKey parsingErrorRuleKey = null;

    @DependedUpon
    public Collection<Metric> generatesNCLOCMetric() {
        return ImmutableList.of((Object)CoreMetrics.NCLOC, (Object)CoreMetrics.NCLOC_DATA);
    }

    public JavaScriptSquidSensor(CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fileSystem, NoSonarFilter noSonarFilter, Settings settings) {
        this(checkFactory, fileLinesContextFactory, resourcePerspectives, fileSystem, noSonarFilter, settings, null);
    }

    public JavaScriptSquidSensor(CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fileSystem, NoSonarFilter noSonarFilter, Settings settings, @Nullable CustomJavaScriptRulesDefinition[] customRulesDefinition) {
        this.checks = JavaScriptChecks.createJavaScriptCheck(checkFactory).addChecks("javascript", CheckList.getChecks()).addCustomChecks(customRulesDefinition);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.fileSystem = fileSystem;
        this.noSonarFilter = noSonarFilter;
        this.mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("js"));
        this.settings = settings;
        this.parser = JavaScriptParserBuilder.createParser((Charset)fileSystem.encoding());
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fileSystem.hasFiles(this.mainFilePredicate);
    }

    public void analyse(Project project, SensorContext context) {
        ArrayList treeVisitors = Lists.newArrayList();
        treeVisitors.add(new MetricsVisitor(this.fileSystem, context, this.noSonarFilter, Boolean.valueOf(this.settings.getBoolean("sonar.javascript.ignoreHeaderComments")), this.fileLinesContextFactory));
        treeVisitors.add(new HighlighterVisitor(this.resourcePerspectives, this.fileSystem));
        treeVisitors.addAll(this.checks.all());
        for (JavaScriptCheck check : treeVisitors) {
            if (!(check instanceof ParsingErrorCheck)) continue;
            this.parsingErrorRuleKey = this.checks.ruleKeyFor(check);
            break;
        }
        ProgressReport progressReport = new ProgressReport("Report about progress of Javascript analyzer", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start((Collection)Lists.newArrayList((Iterable)this.fileSystem.files(this.mainFilePredicate)));
        this.analyseFiles(context, treeVisitors, this.fileSystem.inputFiles(this.mainFilePredicate), progressReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void analyseFiles(SensorContext context, List<JavaScriptCheck> treeVisitors, Iterable<InputFile> inputFiles, ProgressReport progressReport) {
        boolean success = false;
        try {
            for (InputFile inputFile : inputFiles) {
                this.analyse(context, inputFile, treeVisitors);
                progressReport.nextFile();
            }
            success = true;
        }
        finally {
            JavaScriptSquidSensor.stopProgressReport(progressReport, success);
        }
    }

    private static void stopProgressReport(ProgressReport progressReport, boolean success) {
        if (success) {
            progressReport.stop();
        } else {
            progressReport.cancel();
        }
    }

    private void analyse(SensorContext sensorContext, InputFile inputFile, List<JavaScriptCheck> visitors) {
        Issuable issuable = this.perspective(Issuable.class, inputFile);
        try {
            ScriptTree scriptTree = (ScriptTree)this.parser.parse(new File(inputFile.absolutePath()));
            this.scanFile(sensorContext, inputFile, visitors, issuable, scriptTree);
        }
        catch (RecognitionException e) {
            JavaScriptSquidSensor.checkInterrupted((Exception)((Object)e));
            LOG.error("Unable to parse file: " + inputFile.absolutePath());
            LOG.error(e.getMessage());
            this.processRecognitionException(e, issuable);
        }
        catch (Exception e) {
            JavaScriptSquidSensor.checkInterrupted(e);
            throw new AnalysisException("Unable to analyse file: " + inputFile.absolutePath(), (Throwable)e);
        }
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", (Throwable)e);
        }
    }

    private void processRecognitionException(RecognitionException e, Issuable issuable) {
        if (this.parsingErrorRuleKey != null) {
            issuable.addIssue(issuable.newIssueBuilder().ruleKey(this.parsingErrorRuleKey).line(Integer.valueOf(e.getLine())).message(e.getMessage()).build());
        }
    }

    private void scanFile(SensorContext sensorContext, InputFile inputFile, List<JavaScriptCheck> visitors, Issuable issuable, ScriptTree scriptTree) {
        SymbolModelImpl symbolModel = SymbolModelImpl.create((ScriptTree)scriptTree, (Symbolizable)this.perspective(Symbolizable.class, inputFile), (Settings)this.settings);
        for (JavaScriptCheck visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)visitor).setCharset(this.fileSystem.encoding());
            }
            visitor.scanFile((TreeVisitorContext)new JavaScriptCheckContext(sensorContext, scriptTree, issuable, inputFile, (SymbolModel)symbolModel, this.settings, this.checks, new ComplexityVisitor()));
        }
    }

    <P extends Perspective<?>> P perspective(Class<P> clazz, @Nullable InputFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot get " + clazz.getCanonicalName() + "for a null file");
        }
        Perspective result = this.resourcePerspectives.as(clazz, (InputPath)file);
        if (result == null) {
            throw new IllegalStateException("Could not get " + clazz.getCanonicalName() + " for " + file);
        }
        return (P)result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

