/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.CharsetAwareVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S113", priority=Priority.MINOR, name="Files should contain an empty new line at the end", tags={"convention"})
@SqaleConstantRemediation(value="1min")
public class MissingNewlineAtEndOfFileCheck
extends SquidCheck<Grammar>
implements CharsetAwareVisitor {
    public static final String CHECK_KEY = "S113";
    public static final String MESSAGE = "Add a new line at the end of this file \"%s\".";
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitFile(@Nullable AstNode astNode) {
        String fileContent;
        try {
            fileContent = Files.toString((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read " + this.getContext().getFile(), e);
        }
        if (!fileContent.endsWith("\n") && !fileContent.endsWith("\r")) {
            this.getContext().createFileViolation((CodeCheck)this, String.format(MESSAGE, this.getContext().getFile().getName()), new Object[0]);
        }
    }
}

