/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2711", priority=Priority.MAJOR, name="\"yield\" and \"return\" should not be used outside functions", tags={"bug"})
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class ReturnYieldOutsideFunctionCheck
extends PythonCheck {
    public static final String MESSAGE = "Remove this use of \"%s\".";
    public static final String CHECK_KEY = "S2711";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.RETURN_STMT, PythonGrammar.YIELD_STMT});
    }

    public void visitNode(AstNode node) {
        for (AstNode currentParent = node.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (currentParent.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
                return;
            }
            if (!currentParent.is(new AstNodeType[]{PythonGrammar.CLASSDEF})) continue;
            this.raiseIssue(node);
            return;
        }
        this.raiseIssue(node);
    }

    private void raiseIssue(AstNode node) {
        this.addIssue(node, String.format(MESSAGE, node.getToken().getValue()));
    }
}

