/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class NewLineChannel
extends Channel<Lexer> {
    private final LexerState lexerState;

    public NewLineChannel(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    public boolean consume(CodeReader code, Lexer output) {
        char ch = (char)code.peek();
        this.checkForBrackets(ch);
        if (ch == '\\' && NewLineChannel.isNewLine(code.charAt(1))) {
            code.pop();
            this.joinLines(code);
            return true;
        }
        if (NewLineChannel.isNewLine(ch)) {
            if (this.processNewLine(code, output)) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean processNewLine(CodeReader code, Lexer output) {
        if (this.isImplicitLineJoining()) {
            this.joinLines(code);
            return true;
        }
        if (output.getTokens().isEmpty() || ((Token)output.getTokens().get(output.getTokens().size() - 1)).getType().equals((Object)PythonTokenType.NEWLINE)) {
            NewLineChannel.consumeEOL(code);
            return true;
        }
        output.addToken(new Token[]{Token.builder().setLine(code.getLinePosition()).setColumn(code.getColumnPosition()).setURI(output.getURI()).setType((TokenType)PythonTokenType.NEWLINE).setValueAndOriginalValue("\n").setGeneratedCode(true).build()});
        NewLineChannel.consumeEOL(code);
        return false;
    }

    private void checkForBrackets(char ch) {
        switch (ch) {
            case '(': 
            case '[': 
            case '{': {
                ++this.lexerState.brackets;
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                --this.lexerState.brackets;
                break;
            }
        }
    }

    private void joinLines(CodeReader code) {
        while (Character.isWhitespace(code.peek())) {
            code.pop();
        }
        this.lexerState.joined = true;
    }

    private static void consumeEOL(CodeReader code) {
        if (code.charAt(0) == '\r' && code.charAt(1) == '\n') {
            code.pop();
            code.pop();
        } else {
            code.pop();
        }
    }

    private static boolean isNewLine(char ch) {
        return ch == '\n' || ch == '\r';
    }

    private boolean isImplicitLineJoining() {
        return this.lexerState.brackets > 0;
    }
}

