/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Table;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import sootup.core.frontend.BodySource;
import sootup.core.graph.MutableBlockStmtGraph;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.SimpleStmtPositionInfo;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.MethodHandle;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JAddExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JEnterMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.model.Body;
import sootup.core.model.FullPosition;
import sootup.core.model.MethodModifier;
import sootup.core.model.Position;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.SootClassMemberSignature;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.types.VoidType;
import sootup.core.views.View;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.bytecode.frontend.BranchedInsnInfo;
import sootup.java.bytecode.frontend.NonIndexOutofBoundsArrayList;
import sootup.java.bytecode.frontend.Operand;
import sootup.java.bytecode.frontend.OperandMerging;
import sootup.java.bytecode.frontend.OperandStack;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.jimple.basic.JavaLocal;
import sootup.java.core.language.JavaJimple;
import sootup.java.core.types.JavaClassType;

public class AsmMethodSource
extends JSRInlinerAdapter
implements BodySource {
    private int nextLocal;
    private List<JavaLocal> locals;
    private LinkedListMultimap<BranchingStmt, LabelNode> stmtsThatBranchToLabel;
    private Map<AbstractInsnNode, Stmt> insnToStmt;
    @Nonnull
    private final Map<Stmt, Stmt> replacedStmt = new HashMap<Stmt, Stmt>();
    private OperandStack operandStack;
    private Map<LabelNode, Stmt> trapHandler;
    private final Map<LabelNode, TryCatchBlockNode> startTrapHandler = new HashMap<LabelNode, TryCatchBlockNode>();
    private final Map<LabelNode, TryCatchBlockNode> endTrapHandler = new HashMap<LabelNode, TryCatchBlockNode>();
    Set<TryCatchBlockNode> activeTrapHandlers = new HashSet<TryCatchBlockNode>();
    private int currentLineNumber = -1;
    private int maxLineNumber = 0;
    @Nullable
    private JavaClassType declaringClass;
    private final View view;
    private final List<BodyInterceptor> bodyInterceptors;
    @Nonnull
    private final Set<LabelNode> inlineExceptionLabels = new HashSet<LabelNode>();
    @Nonnull
    private final Map<LabelNode, JIdentityStmt> inlineExceptionHandlers = new HashMap<LabelNode, JIdentityStmt>();
    @Nonnull
    private final Map<LabelNode, Stmt> labelsToStmt = new HashMap<LabelNode, Stmt>();
    private final JavaIdentifierFactory identifierFactory;
    private final Supplier<MethodSignature> lazyMethodSignature;

    AsmMethodSource(int access, @Nonnull String name, @Nonnull String desc, @Nonnull String signature, @Nonnull String[] exceptions, View view, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        super(589824, null, access, name, desc, signature, exceptions);
        this.bodyInterceptors = bodyInterceptors;
        this.view = view;
        this.identifierFactory = (JavaIdentifierFactory)view.getIdentifierFactory();
        this.lazyMethodSignature = Suppliers.memoize(() -> {
            List<Type> sigTypes = AsmUtil.toJimpleSignatureDesc(desc);
            Type retType = sigTypes.remove(sigTypes.size() - 1);
            return this.identifierFactory.getMethodSignature((ClassType)this.declaringClass, name, retType, sigTypes);
        });
    }

    @Nonnull
    public MethodSignature getSignature() {
        return this.lazyMethodSignature.get();
    }

    void setDeclaringClass(@Nonnull ClassType declaringClass) {
        this.declaringClass = (JavaClassType)declaringClass;
    }

    StmtPositionInfo getStmtPositionInfo() {
        return this.currentLineNumber > 0 ? new SimpleStmtPositionInfo(this.currentLineNumber) : StmtPositionInfo.getNoStmtPositionInfo();
    }

    @Nonnull
    public Body resolveBody(@Nonnull Iterable<MethodModifier> modifierIt) {
        this.nextLocal = this.maxLocals;
        this.locals = new NonIndexOutofBoundsArrayList<JavaLocal>(this.maxLocals + Math.max(this.maxLocals / 2, 5));
        this.stmtsThatBranchToLabel = LinkedListMultimap.create();
        this.insnToStmt = new LinkedHashMap<AbstractInsnNode, Stmt>(this.instructions.size());
        this.operandStack = new OperandStack(this, this.instructions.size());
        this.trapHandler = new LinkedHashMap<LabelNode, Stmt>(this.tryCatchBlocks.size());
        for (TryCatchBlockNode tc : this.tryCatchBlocks) {
            this.trapHandler.put(tc.handler, null);
            this.startTrapHandler.put(tc.start, tc);
            this.endTrapHandler.put(tc.end, tc);
        }
        MutableBlockStmtGraph graph = new MutableBlockStmtGraph();
        Body.BodyBuilder bodyBuilder = Body.builder((MutableStmtGraph)graph);
        bodyBuilder.setModifiers(AsmUtil.getMethodModifiers(this.access));
        List<Stmt> preambleStmts = this.buildPreambleLocals(bodyBuilder);
        try {
            this.convert();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + this.lazyMethodSignature.get(), e);
        }
        Set bodyLocals = this.locals.stream().filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        bodyBuilder.setLocals(bodyLocals);
        try {
            this.arrangeStmts(graph, preambleStmts, bodyBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + this.lazyMethodSignature.get(), e);
        }
        Stmt startingStmt = graph.getStartingStmt();
        if (!graph.getNodes().isEmpty() && startingStmt != null) {
            Position firstStmtPos = startingStmt.getPositionInfo().getStmtPosition();
            bodyBuilder.setPosition((Position)new FullPosition(firstStmtPos.getFirstLine(), firstStmtPos.getFirstCol(), this.maxLineNumber, Integer.MAX_VALUE));
        } else {
            bodyBuilder.setPosition((Position)NoPositionInformation.getInstance());
        }
        this.locals = null;
        this.stmtsThatBranchToLabel = null;
        this.insnToStmt = null;
        this.operandStack = null;
        bodyBuilder.setMethodSignature(this.lazyMethodSignature.get());
        for (BodyInterceptor bodyInterceptor : this.bodyInterceptors) {
            try {
                bodyInterceptor.interceptBody(bodyBuilder, this.view);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to apply " + bodyInterceptor + " to " + this.lazyMethodSignature.get(), e);
            }
        }
        return bodyBuilder.build();
    }

    public Object resolveAnnotationsDefaultValue() {
        return this.resolveAnnotationsInDefaultValue(this.annotationDefault);
    }

    private Object resolveAnnotationsInDefaultValue(Object a) {
        if (a instanceof AnnotationNode) {
            return AsmUtil.createAnnotationUsage(Collections.singletonList((AnnotationNode)a));
        }
        if (a instanceof ArrayList) {
            ArrayList list = new ArrayList();
            ((ArrayList)a).forEach(e -> list.add(this.resolveAnnotationsInDefaultValue(e)));
            return list;
        }
        return AsmUtil.convertAnnotationValue(a);
    }

    @Nonnull
    private JavaLocal getOrCreateLocal(int idx) {
        if (idx >= this.maxLocals) {
            throw new IllegalArgumentException("Invalid local index: " + idx);
        }
        JavaLocal local = this.locals.get(idx);
        if (local == null) {
            String name = this.determineLocalName(idx);
            local = JavaJimple.newLocal((String)name, (Type)UnknownType.getInstance(), Collections.emptyList());
            this.locals.set(idx, local);
        }
        return local;
    }

    @Nonnull
    private String determineLocalName(int idx) {
        String name;
        if (this.localVariables != null) {
            name = null;
            for (LocalVariableNode lvn : this.localVariables) {
                if (lvn.index != idx) continue;
                name = lvn.name;
                break;
            }
            if (name == null) {
                name = "l" + idx;
            }
        } else {
            name = "l" + idx;
        }
        return name;
    }

    void setStmt(@Nonnull AbstractInsnNode insn, @Nonnull Stmt stmt) {
        this.insnToStmt.put(insn, stmt);
    }

    @Nonnull
    Local newStackLocal() {
        int idx = this.nextLocal++;
        JavaLocal l = JavaJimple.newLocal((String)("$stack" + idx), (Type)UnknownType.getInstance(), Collections.emptyList());
        this.locals.set(idx, l);
        return l;
    }

    <A extends Stmt> A getStmt(@Nonnull AbstractInsnNode insn) {
        return (A)this.insnToStmt.get(insn);
    }

    private void addReadOperandAssignments() {
        this.addReadOperandAssignments_internal((opValue, operand) -> {
            if (opValue instanceof Local) {
                return true;
            }
            int op = operand.insn.getOpcode();
            return op != 180 && op != 178 && (op < 46 || op > 53);
        });
    }

    private void addReadOperandAssignments(@Nonnull Local local) {
        this.addReadOperandAssignments_internal((opValue, operand) -> {
            if (!opValue.equivTo((Object)local)) {
                boolean noRef = true;
                for (Value use : opValue.getUses()) {
                    if (!use.equivTo((Object)local)) continue;
                    noRef = false;
                    break;
                }
                return noRef;
            }
            return false;
        });
    }

    private void addReadOperandAssignments_internal(BiFunction<Value, Operand, Boolean> func) {
        for (Operand operand : this.operandStack.getStack()) {
            Value opValue = operand.value;
            if (operand == Operand.DWORD_DUMMY || operand.stackLocal != null || func.apply(opValue, operand).booleanValue()) continue;
            operand.emitStatement();
        }
    }

    private void convertGetFieldInsn(@Nonnull FieldInsnNode insn) {
        JStaticFieldRef val;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Type type = AsmUtil.toJimpleType(insn.desc);
        JavaClassType declClass = this.identifierFactory.getClassType(AsmUtil.toQualifiedName(insn.owner));
        if (insn.getOpcode() == 178) {
            FieldSignature ref = this.identifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
            val = Jimple.newStaticFieldRef((FieldSignature)ref);
        } else {
            Operand base = this.operandStack.pop();
            merging.mergeInputs(base);
            FieldSignature ref = this.identifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
            val = Jimple.newInstanceFieldRef((Local)base.toLocal(), (FieldSignature)ref);
        }
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)val, this);
        merging.mergeOutput(opr);
        this.operandStack.push(type, opr);
    }

    private void convertPutFieldInsn(@Nonnull FieldInsnNode insn) {
        JStaticFieldRef val;
        boolean notInstance = insn.getOpcode() != 181;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        JavaClassType declClass = this.identifierFactory.getClassType(AsmUtil.toQualifiedName(insn.owner));
        Type type = AsmUtil.toJimpleType(insn.desc);
        Operand rvalue = this.operandStack.pop(type);
        if (notInstance) {
            merging.mergeInputs(rvalue);
            FieldSignature ref = this.identifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
            val = Jimple.newStaticFieldRef((FieldSignature)ref);
        } else {
            Operand base = this.operandStack.pop();
            merging.mergeInputs(rvalue, base);
            FieldSignature ref = this.identifierFactory.getFieldSignature(insn.name, (ClassType)declClass, type);
            val = Jimple.newInstanceFieldRef((Local)base.toLocal(), (FieldSignature)ref);
        }
        JAssignStmt as = Jimple.newAssignStmt((LValue)val, (Value)rvalue.toImmediate(), (StmtPositionInfo)this.getStmtPositionInfo());
        this.setStmt((AbstractInsnNode)insn, (Stmt)as);
        this.addReadOperandAssignments();
    }

    private void convertFieldInsn(@Nonnull FieldInsnNode insn) {
        int op = insn.getOpcode();
        if (op == 178 || op == 180) {
            this.convertGetFieldInsn(insn);
        } else {
            this.convertPutFieldInsn(insn);
        }
    }

    private void convertIincInsn(@Nonnull IincInsnNode insn) {
        JavaLocal local = this.getOrCreateLocal(insn.var);
        this.addReadOperandAssignments((Local)local);
        JAddExpr add = Jimple.newAddExpr((Immediate)local, (Immediate)IntConstant.getInstance((int)insn.incr));
        this.setStmt((AbstractInsnNode)insn, (Stmt)Jimple.newAssignStmt((LValue)local, (Value)add, (StmtPositionInfo)this.getStmtPositionInfo()));
    }

    private void convertConstInsn(@Nonnull InsnNode insn) {
        NullConstant v;
        int op = insn.getOpcode();
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        if (op == 1) {
            v = NullConstant.getInstance();
        } else if (op >= 2 && op <= 8) {
            v = IntConstant.getInstance((int)(op - 3));
        } else if (op == 9 || op == 10) {
            v = LongConstant.getInstance((long)(op - 9));
        } else if (op >= 11 && op <= 13) {
            v = FloatConstant.getInstance((float)(op - 11));
        } else if (op == 14 || op == 15) {
            v = DoubleConstant.getInstance((double)(op - 14));
        } else {
            throw new UnsupportedOperationException("Unknown constant opcode: " + op);
        }
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)v, this);
        merging.mergeOutput(opr);
        if (op == 9 || op == 10 || op == 14 || op == 15) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertArrayLoadInsn(@Nonnull InsnNode insn) {
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand indx = this.operandStack.pop();
        Operand base = this.operandStack.pop();
        merging.mergeInputs(indx, base);
        JArrayRef ar = JavaJimple.getInstance().newArrayRef(base.toLocal(), indx.toImmediate());
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)ar, this);
        merging.mergeOutput(opr);
        int op = insn.getOpcode();
        if (op == 49 || op == 47) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertArrayStoreInsn(@Nonnull InsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 80 || op == 82;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand valueOp = dword ? this.operandStack.popDual() : this.operandStack.pop();
        Operand indexOp = this.operandStack.pop();
        Operand baseOp = this.operandStack.pop();
        merging.mergeInputs(valueOp, indexOp, baseOp);
        JArrayRef ar = JavaJimple.getInstance().newArrayRef(baseOp.toLocal(), indexOp.toImmediate());
        JAssignStmt as = Jimple.newAssignStmt((LValue)ar, (Value)valueOp.toImmediate(), (StmtPositionInfo)this.getStmtPositionInfo());
        this.setStmt((AbstractInsnNode)insn, (Stmt)as);
    }

    private void convertDupInsn(@Nonnull InsnNode insn) {
        boolean dword;
        int op = insn.getOpcode();
        Operand dupd = this.operandStack.pop();
        Operand dupd2 = null;
        boolean bl = dword = op == 92 || op == 93 || op == 94;
        if (dword) {
            if (this.operandStack.peek() == Operand.DWORD_DUMMY) {
                this.operandStack.pop();
                dupd2 = dupd;
            } else {
                dupd2 = this.operandStack.pop();
            }
        }
        if (op == 89) {
            this.operandStack.push(dupd);
            this.operandStack.push(dupd);
        } else if (op == 90) {
            Operand o2 = this.operandStack.pop();
            this.operandStack.push(dupd);
            this.operandStack.push(o2);
            this.operandStack.push(dupd);
        } else if (op == 91) {
            Operand o2 = this.operandStack.pop();
            Operand o3 = this.operandStack.pop();
            this.operandStack.push(dupd);
            this.operandStack.push(o3);
            this.operandStack.push(o2);
            this.operandStack.push(dupd);
        } else if (op == 92) {
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
        } else if (op == 93) {
            Operand o2 = this.operandStack.pop();
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
            this.operandStack.push(o2);
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
        } else if (op == 94) {
            Operand o2 = this.operandStack.pop();
            Operand o2h = this.operandStack.pop();
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
            this.operandStack.push(o2h);
            this.operandStack.push(o2);
            this.operandStack.push(dupd2);
            this.operandStack.push(dupd);
        }
    }

    private void convertBinopInsn(@Nonnull InsnNode insn) {
        JAddExpr binop;
        int op = insn.getOpcode();
        boolean dword = op == 99 || op == 97 || op == 103 || op == 101 || op == 107 || op == 105 || op == 111 || op == 109 || op == 115 || op == 113 || op == 121 || op == 123 || op == 125 || op == 127 || op == 129 || op == 131 || op == 148 || op == 151 || op == 152;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand op2 = dword && op != 121 && op != 123 && op != 125 ? this.operandStack.popDual() : this.operandStack.pop();
        Operand op1 = dword ? this.operandStack.popDual() : this.operandStack.pop();
        merging.mergeInputs(op2, op1);
        Immediate v1 = op1.toImmediate();
        Immediate v2 = op2.toImmediate();
        if (op >= 96 && op <= 99) {
            binop = Jimple.newAddExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 100 && op <= 103) {
            binop = Jimple.newSubExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 104 && op <= 107) {
            binop = Jimple.newMulExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 108 && op <= 111) {
            binop = Jimple.newDivExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 112 && op <= 115) {
            binop = Jimple.newRemExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 120 && op <= 121) {
            binop = Jimple.newShlExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 122 && op <= 123) {
            binop = Jimple.newShrExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 124 && op <= 125) {
            binop = Jimple.newUshrExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 126 && op <= 127) {
            binop = Jimple.newAndExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 128 && op <= 129) {
            binop = Jimple.newOrExpr((Immediate)v1, (Immediate)v2);
        } else if (op >= 130 && op <= 131) {
            binop = Jimple.newXorExpr((Immediate)v1, (Immediate)v2);
        } else if (op == 148) {
            binop = Jimple.newCmpExpr((Immediate)v1, (Immediate)v2);
        } else if (op == 149 || op == 151) {
            binop = Jimple.newCmplExpr((Immediate)v1, (Immediate)v2);
        } else if (op == 150 || op == 152) {
            binop = Jimple.newCmpgExpr((Immediate)v1, (Immediate)v2);
        } else {
            throw new UnsupportedOperationException("Unknown binop: " + op);
        }
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)binop, this);
        merging.mergeOutput(opr);
        if (dword && op < 148) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertUnopInsn(@Nonnull InsnNode insn) {
        JNegExpr unop;
        int op = insn.getOpcode();
        boolean dword = op == 117 || op == 119;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand op1 = dword ? this.operandStack.popDual() : this.operandStack.pop();
        merging.mergeInputs(op1);
        if (op >= 116 && op <= 119) {
            unop = Jimple.newNegExpr((Immediate)op1.toImmediate());
        } else if (op == 190) {
            unop = Jimple.newLengthExpr((Immediate)op1.toImmediate());
        } else {
            throw new UnsupportedOperationException("Unknown unop: " + op);
        }
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)unop, this);
        merging.mergeOutput(opr);
        if (dword) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertPrimCastInsn(@Nonnull InsnNode insn) {
        PrimitiveType.LongType totype;
        int op = insn.getOpcode();
        boolean tod = op == 133 || op == 135 || op == 140 || op == 141 || op == 143 || op == 138;
        boolean fromd = op == 143 || op == 138 || op == 142 || op == 136 || op == 144 || op == 137;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        switch (op) {
            case 133: 
            case 140: 
            case 143: {
                totype = PrimitiveType.getLong();
                break;
            }
            case 136: 
            case 139: 
            case 142: {
                totype = PrimitiveType.getInt();
                break;
            }
            case 134: 
            case 137: 
            case 144: {
                totype = PrimitiveType.getFloat();
                break;
            }
            case 135: 
            case 138: 
            case 141: {
                totype = PrimitiveType.getDouble();
                break;
            }
            case 145: {
                totype = PrimitiveType.getByte();
                break;
            }
            case 147: {
                totype = PrimitiveType.getShort();
                break;
            }
            case 146: {
                totype = PrimitiveType.getChar();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown prim cast op: " + op);
            }
        }
        Operand val = fromd ? this.operandStack.popDual() : this.operandStack.pop();
        merging.mergeInputs(val);
        JCastExpr cast = Jimple.newCastExpr((Immediate)val.toImmediate(), (Type)totype);
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)cast, this);
        merging.mergeOutput(opr);
        if (tod) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertReturnInsn(@Nonnull InsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 173 || op == 175;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand val = dword ? this.operandStack.popDual() : this.operandStack.pop();
        merging.mergeInputs(val);
        JReturnStmt ret = Jimple.newReturnStmt((Immediate)val.toImmediate(), (StmtPositionInfo)this.getStmtPositionInfo());
        this.setStmt((AbstractInsnNode)insn, (Stmt)ret);
    }

    private void convertInsn(@Nonnull InsnNode insn) {
        int op = insn.getOpcode();
        if (op == 0) {
            this.setStmt((AbstractInsnNode)insn, (Stmt)Jimple.newNopStmt((StmtPositionInfo)this.getStmtPositionInfo()));
        } else if (op >= 1 && op <= 15) {
            this.convertConstInsn(insn);
        } else if (op >= 46 && op <= 53) {
            this.convertArrayLoadInsn(insn);
        } else if (op >= 79 && op <= 86) {
            this.convertArrayStoreInsn(insn);
        } else if (op == 87) {
            this.operandStack.pop().emitStatement();
        } else if (op == 88) {
            this.operandStack.pop().emitStatement();
            this.operandStack.pop().emitStatement();
        } else if (op >= 89 && op <= 94) {
            this.convertDupInsn(insn);
        } else if (op == 95) {
            Operand o1 = this.operandStack.pop();
            Operand o2 = this.operandStack.pop();
            this.operandStack.push(o1);
            this.operandStack.push(o2);
        } else if (op >= 96 && op <= 115 || op >= 120 && op <= 131 || op >= 148 && op <= 152) {
            this.convertBinopInsn(insn);
        } else if (op >= 116 && op <= 119 || op == 190) {
            this.convertUnopInsn(insn);
        } else if (op >= 133 && op <= 147) {
            this.convertPrimCastInsn(insn);
        } else if (op >= 172 && op <= 176) {
            this.convertReturnInsn(insn);
        } else if (op == 177) {
            this.setStmt((AbstractInsnNode)insn, (Stmt)Jimple.newReturnVoidStmt((StmtPositionInfo)this.getStmtPositionInfo()));
        } else if (op == 191) {
            OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
            Operand opr = this.operandStack.pop();
            merging.mergeInputs(opr);
            JThrowStmt ts = Jimple.newThrowStmt((Immediate)opr.toImmediate(), (StmtPositionInfo)this.getStmtPositionInfo());
            this.setStmt((AbstractInsnNode)insn, (Stmt)ts);
            merging.mergeOutput(opr);
            this.operandStack.push(opr);
        } else if (op == 194 || op == 195) {
            OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
            Operand opr = this.operandStack.popStackConst();
            merging.mergeInputs(opr);
            JEnterMonitorStmt ts = op == 194 ? Jimple.newEnterMonitorStmt((Immediate)opr.toImmediate(), (StmtPositionInfo)this.getStmtPositionInfo()) : Jimple.newExitMonitorStmt((Immediate)opr.toImmediate(), (StmtPositionInfo)this.getStmtPositionInfo());
            this.setStmt((AbstractInsnNode)insn, (Stmt)ts);
        } else {
            throw new UnsupportedOperationException("Unknown insn op: " + op);
        }
    }

    private void convertIntInsn(@Nonnull IntInsnNode insn) {
        IntConstant v;
        int op = insn.getOpcode();
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        if (op == 16 || op == 17) {
            v = IntConstant.getInstance((int)insn.operand);
        } else {
            PrimitiveType.BooleanType type;
            assert (op == 188);
            switch (insn.operand) {
                case 4: {
                    type = PrimitiveType.getBoolean();
                    break;
                }
                case 5: {
                    type = PrimitiveType.getChar();
                    break;
                }
                case 6: {
                    type = PrimitiveType.getFloat();
                    break;
                }
                case 7: {
                    type = PrimitiveType.getDouble();
                    break;
                }
                case 8: {
                    type = PrimitiveType.getByte();
                    break;
                }
                case 9: {
                    type = PrimitiveType.getShort();
                    break;
                }
                case 10: {
                    type = PrimitiveType.getInt();
                    break;
                }
                case 11: {
                    type = PrimitiveType.getLong();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown NEWARRAY type!");
                }
            }
            Operand size = this.operandStack.pop();
            merging.mergeInputs(size);
            v = JavaJimple.getInstance().newNewArrayExpr((Type)type, size.toImmediate());
        }
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)v, this);
        merging.mergeOutput(opr);
        this.operandStack.push(opr);
    }

    private void convertJumpInsn(@Nonnull JumpInsnNode insn) {
        JEqExpr cond;
        int op = insn.getOpcode();
        if (op == 167) {
            JGotoStmt gotoStmt = Jimple.newGotoStmt((StmtPositionInfo)this.getStmtPositionInfo());
            this.stmtsThatBranchToLabel.put((Object)gotoStmt, (Object)insn.label);
            this.setStmt((AbstractInsnNode)insn, (Stmt)gotoStmt);
            return;
        }
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand val = this.operandStack.pop();
        Immediate v = val.toImmediate();
        if (op >= 159 && op <= 166) {
            Operand val1 = this.operandStack.pop();
            merging.mergeInputs(val, val1);
            Immediate v1 = val1.toImmediate();
            switch (op) {
                case 159: 
                case 165: {
                    cond = Jimple.newEqExpr((Immediate)v1, (Immediate)v);
                    break;
                }
                case 160: 
                case 166: {
                    cond = Jimple.newNeExpr((Immediate)v1, (Immediate)v);
                    break;
                }
                case 161: {
                    cond = Jimple.newLtExpr((Immediate)v1, (Immediate)v);
                    break;
                }
                case 162: {
                    cond = Jimple.newGeExpr((Immediate)v1, (Immediate)v);
                    break;
                }
                case 163: {
                    cond = Jimple.newGtExpr((Immediate)v1, (Immediate)v);
                    break;
                }
                case 164: {
                    cond = Jimple.newLeExpr((Immediate)v1, (Immediate)v);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown if op: " + op);
                }
            }
        } else {
            merging.mergeInputs(val);
            switch (op) {
                case 153: {
                    cond = Jimple.newEqExpr((Immediate)v, (Immediate)IntConstant.getInstance((int)0));
                    break;
                }
                case 154: {
                    cond = Jimple.newNeExpr((Immediate)v, (Immediate)IntConstant.getInstance((int)0));
                    break;
                }
                case 155: {
                    cond = Jimple.newLtExpr((Immediate)v, (Immediate)IntConstant.getInstance((int)0));
                    break;
                }
                case 156: {
                    cond = Jimple.newGeExpr((Immediate)v, (Immediate)IntConstant.getInstance((int)0));
                    break;
                }
                case 157: {
                    cond = Jimple.newGtExpr((Immediate)v, (Immediate)IntConstant.getInstance((int)0));
                    break;
                }
                case 158: {
                    cond = Jimple.newLeExpr((Immediate)v, (Immediate)IntConstant.getInstance((int)0));
                    break;
                }
                case 198: {
                    cond = Jimple.newEqExpr((Immediate)v, (Immediate)NullConstant.getInstance());
                    break;
                }
                case 199: {
                    cond = Jimple.newNeExpr((Immediate)v, (Immediate)NullConstant.getInstance());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown if op: " + op);
                }
            }
        }
        JIfStmt ifStmt = Jimple.newIfStmt((AbstractConditionExpr)cond, (StmtPositionInfo)this.getStmtPositionInfo());
        this.stmtsThatBranchToLabel.put((Object)ifStmt, (Object)insn.label);
        this.setStmt((AbstractInsnNode)insn, (Stmt)ifStmt);
    }

    private void convertLdcInsn(@Nonnull LdcInsnNode insn) {
        Object val = insn.cst;
        boolean dword = val instanceof Long || val instanceof Double;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Immediate v = this.toSootValue(val);
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)v, this);
        merging.mergeOutput(opr);
        if (dword) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private Immediate toSootValue(@Nonnull Object val) throws UnsupportedOperationException {
        IntConstant v;
        if (val instanceof Integer) {
            v = IntConstant.getInstance((int)((Integer)val));
        } else if (val instanceof Float) {
            v = FloatConstant.getInstance((float)((Float)val).floatValue());
        } else if (val instanceof Long) {
            v = LongConstant.getInstance((long)((Long)val));
        } else if (val instanceof Double) {
            v = DoubleConstant.getInstance((double)((Double)val));
        } else if (val instanceof String) {
            v = JavaJimple.getInstance().newStringConstant(val.toString());
        } else if (val instanceof org.objectweb.asm.Type) {
            org.objectweb.asm.Type t = (org.objectweb.asm.Type)val;
            if (t.getSort() == 11) {
                List<Type> paramTypes = AsmUtil.toJimpleSignatureDesc(((org.objectweb.asm.Type)val).getDescriptor());
                Type returnType = paramTypes.remove(paramTypes.size() - 1);
                v = JavaJimple.getInstance().newMethodType(paramTypes, returnType);
            } else {
                v = JavaJimple.getInstance().newClassConstant(((org.objectweb.asm.Type)val).getDescriptor());
            }
        } else if (val instanceof Handle) {
            Handle h = (Handle)val;
            v = MethodHandle.isMethodRef((int)h.getTag()) ? JavaJimple.getInstance().newMethodHandle((SootClassMemberSignature)this.toMethodSignature((Handle)val), ((Handle)val).getTag()) : JavaJimple.getInstance().newMethodHandle((SootClassMemberSignature)this.toSootFieldSignature((Handle)val), ((Handle)val).getTag());
        } else {
            throw new UnsupportedOperationException("Unknown constant type: " + val.getClass());
        }
        return v;
    }

    private JFieldRef toSootFieldRef(Handle methodHandle) {
        String bsmClsName = AsmUtil.toQualifiedName(methodHandle.getOwner());
        JavaClassType bsmCls = this.identifierFactory.getClassType(bsmClsName);
        Type t = AsmUtil.toJimpleSignatureDesc(methodHandle.getDesc()).get(0);
        int kind = methodHandle.getTag();
        FieldSignature fieldSignature = this.identifierFactory.getFieldSignature(methodHandle.getName(), (ClassType)bsmCls, t);
        if (kind == MethodHandle.Kind.REF_GET_FIELD_STATIC.getValue() || kind == MethodHandle.Kind.REF_PUT_FIELD_STATIC.getValue()) {
            return Jimple.newStaticFieldRef((FieldSignature)fieldSignature);
        }
        Operand base = this.operandStack.pop();
        return Jimple.newInstanceFieldRef((Local)base.toLocal(), (FieldSignature)fieldSignature);
    }

    private FieldSignature toSootFieldSignature(Handle methodHandle) {
        String bsmClsName = AsmUtil.toQualifiedName(methodHandle.getOwner());
        JavaClassType bsmCls = this.identifierFactory.getClassType(bsmClsName);
        Type t = AsmUtil.toJimpleSignatureDesc(methodHandle.getDesc()).get(0);
        return this.identifierFactory.getFieldSignature(methodHandle.getName(), (ClassType)bsmCls, t);
    }

    private MethodSignature toMethodSignature(Handle methodHandle) {
        String bsmClsName = AsmUtil.toQualifiedName(methodHandle.getOwner());
        JavaClassType bsmCls = this.identifierFactory.getClassType(bsmClsName);
        List<Type> bsmSigTypes = AsmUtil.toJimpleSignatureDesc(methodHandle.getDesc());
        Type returnType = bsmSigTypes.remove(bsmSigTypes.size() - 1);
        return JavaIdentifierFactory.getInstance().getMethodSignature((ClassType)bsmCls, methodHandle.getName(), returnType, bsmSigTypes);
    }

    private void convertLookupSwitchInsn(@Nonnull LookupSwitchInsnNode insn) {
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        if (this.insnToStmt.containsKey(insn)) {
            merging.mergeInputs(this.operandStack.pop());
            return;
        }
        Operand key = this.operandStack.pop();
        merging.mergeInputs(key);
        ArrayList<IntConstant> keys = new ArrayList<IntConstant>(insn.keys.size());
        for (Integer i : insn.keys) {
            keys.add(IntConstant.getInstance((int)i));
        }
        JSwitchStmt lookupSwitchStmt = Jimple.newLookupSwitchStmt((Immediate)key.toImmediate(), keys, (StmtPositionInfo)this.getStmtPositionInfo());
        this.stmtsThatBranchToLabel.putAll((Object)lookupSwitchStmt, (Iterable)insn.labels);
        this.stmtsThatBranchToLabel.put((Object)lookupSwitchStmt, (Object)insn.dflt);
        this.setStmt((AbstractInsnNode)insn, (Stmt)lookupSwitchStmt);
    }

    private void convertMethodInsn(@Nonnull MethodInsnNode insn) {
        JStaticInvokeExpr invoke;
        int op = insn.getOpcode();
        boolean isInstance = op != 184;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        String clsName = AsmUtil.toQualifiedName(insn.owner);
        if (clsName.charAt(0) == '[') {
            clsName = "java.lang.Object";
        }
        JavaClassType cls = this.identifierFactory.getClassType(AsmUtil.toQualifiedName(clsName));
        List<Type> sigTypes = AsmUtil.toJimpleSignatureDesc(insn.desc);
        Type returnType = sigTypes.remove(sigTypes.size() - 1);
        MethodSignature methodSignature = this.identifierFactory.getMethodSignature((ClassType)cls, insn.name, returnType, sigTypes);
        int nrArgs = sigTypes.size();
        Immediate[] argList = new Immediate[nrArgs];
        Operand[] operands = !isInstance ? (nrArgs == 0 ? null : new Operand[nrArgs]) : new Operand[nrArgs + 1];
        while (nrArgs-- != 0) {
            operands[nrArgs] = this.operandStack.pop(sigTypes.get(nrArgs));
        }
        if (isInstance) {
            operands[operands.length - 1] = this.operandStack.pop();
        }
        if (operands != null) {
            merging.mergeInputs(operands);
        }
        nrArgs = sigTypes.size();
        while (nrArgs-- != 0) {
            argList[nrArgs] = operands[nrArgs].toImmediate();
        }
        List<Immediate> args = Arrays.asList(argList);
        if (!isInstance) {
            invoke = Jimple.newStaticInvokeExpr((MethodSignature)methodSignature, args);
        } else {
            Operand baseOperand = operands[operands.length - 1];
            Local base = baseOperand.toLocal();
            switch (op) {
                case 183: {
                    invoke = Jimple.newSpecialInvokeExpr((Local)base, (MethodSignature)methodSignature, args);
                    break;
                }
                case 182: {
                    invoke = Jimple.newVirtualInvokeExpr((Local)base, (MethodSignature)methodSignature, args);
                    break;
                }
                case 185: {
                    invoke = Jimple.newInterfaceInvokeExpr((Local)base, (MethodSignature)methodSignature, args);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown invoke op:" + op);
                }
            }
        }
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)invoke, this);
        merging.mergeOutput(opr);
        if (AsmUtil.isDWord(returnType)) {
            this.operandStack.pushDual(opr);
        } else if (returnType != VoidType.getInstance()) {
            this.operandStack.push(opr);
        } else {
            JInvokeStmt stmt = Jimple.newInvokeStmt((AbstractInvokeExpr)((AbstractInvokeExpr)opr.value), (StmtPositionInfo)this.getStmtPositionInfo());
            this.setStmt((AbstractInsnNode)insn, (Stmt)stmt);
        }
        this.addReadOperandAssignments();
    }

    private void convertInvokeDynamicInsn(@Nonnull InvokeDynamicInsnNode insn) {
        int i;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        MethodSignature bsmMethodRef = this.toMethodSignature(insn.bsm);
        ArrayList<Immediate> bsmMethodArgs = new ArrayList<Immediate>(insn.bsmArgs.length);
        for (Object bsmArg : insn.bsmArgs) {
            bsmMethodArgs.add(this.toSootValue(bsmArg));
        }
        JavaClassType bclass = this.identifierFactory.getClassType("sootup.dummy.InvokeDynamic");
        List<Type> types = AsmUtil.toJimpleSignatureDesc(insn.desc);
        int nrArgs = types.size() - 1;
        Type[] parameterTypes = new Type[nrArgs];
        Immediate[] methodArgs = new Immediate[nrArgs];
        Operand[] args = new Operand[nrArgs];
        for (i = nrArgs - 1; i >= 0; --i) {
            parameterTypes[i] = types.get(i);
            args[i] = this.operandStack.pop(types.get(i));
        }
        merging.mergeInputs(args);
        for (i = nrArgs - 1; i >= 0; --i) {
            methodArgs[i] = args[i].toImmediate();
        }
        Type returnType = types.get(types.size() - 1);
        MethodSignature methodSig = this.identifierFactory.getMethodSignature((ClassType)bclass, insn.name, returnType, Arrays.asList(parameterTypes));
        JDynamicInvokeExpr indy = Jimple.newDynamicInvokeExpr((MethodSignature)bsmMethodRef, bsmMethodArgs, (MethodSignature)methodSig, (int)insn.bsm.getTag(), Arrays.asList(methodArgs));
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)indy, this);
        merging.mergeOutput(opr);
        if (AsmUtil.isDWord(returnType)) {
            this.operandStack.pushDual(opr);
        } else if (!(returnType instanceof VoidType)) {
            this.operandStack.push(opr);
        } else {
            JInvokeStmt stmt = Jimple.newInvokeStmt((AbstractInvokeExpr)((AbstractInvokeExpr)opr.value), (StmtPositionInfo)this.getStmtPositionInfo());
            this.setStmt((AbstractInsnNode)insn, (Stmt)stmt);
        }
        this.addReadOperandAssignments();
    }

    private void convertMultiANewArrayInsn(@Nonnull MultiANewArrayInsnNode insn) {
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        ArrayType t = (ArrayType)AsmUtil.toJimpleType(insn.desc);
        int dims = insn.dims;
        Operand[] sizes = new Operand[dims];
        Immediate[] sizeVals = new Immediate[dims];
        while (dims-- != 0) {
            sizes[dims] = this.operandStack.pop();
        }
        merging.mergeInputs(sizes);
        dims = insn.dims;
        while (dims-- != 0) {
            sizeVals[dims] = sizes[dims].toImmediate();
        }
        JNewMultiArrayExpr nm = Jimple.newNewMultiArrayExpr((ArrayType)t, Arrays.asList(sizeVals));
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)nm, this);
        merging.mergeOutput(opr);
        this.operandStack.push(opr);
    }

    private void convertTableSwitchInsn(@Nonnull TableSwitchInsnNode insn) {
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        if (this.insnToStmt.containsKey(insn)) {
            merging.mergeInputs(this.operandStack.pop());
            return;
        }
        Operand key = this.operandStack.pop();
        merging.mergeInputs(key);
        JSwitchStmt tableSwitchStmt = Jimple.newTableSwitchStmt((Immediate)key.toImmediate(), (int)insn.min, (int)insn.max, (StmtPositionInfo)this.getStmtPositionInfo());
        this.stmtsThatBranchToLabel.putAll((Object)tableSwitchStmt, (Iterable)insn.labels);
        this.stmtsThatBranchToLabel.put((Object)tableSwitchStmt, (Object)insn.dflt);
        this.setStmt((AbstractInsnNode)insn, (Stmt)tableSwitchStmt);
    }

    private void convertTypeInsn(@Nonnull TypeInsnNode insn) {
        JNewExpr val;
        int op = insn.getOpcode();
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        if (op == 187) {
            val = Jimple.newNewExpr((ClassType)AsmUtil.toJimpleClassType(insn.desc));
        } else {
            Operand op1 = this.operandStack.pop();
            merging.mergeInputs(op1);
            switch (op) {
                case 189: {
                    val = JavaJimple.getInstance().newNewArrayExpr(AsmUtil.arrayTypetoJimpleType(insn.desc), op1.toImmediate());
                    break;
                }
                case 192: {
                    val = Jimple.newCastExpr((Immediate)op1.toImmediate(), (Type)AsmUtil.arrayTypetoJimpleType(insn.desc));
                    break;
                }
                case 193: {
                    val = Jimple.newInstanceOfExpr((Immediate)op1.toImmediate(), (Type)AsmUtil.toJimpleClassType(insn.desc));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type op: " + op);
                }
            }
        }
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)val, this);
        merging.mergeOutput(opr);
        this.operandStack.push(opr);
    }

    private void convertVarLoadInsn(@Nonnull VarInsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 22 || op == 24;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand opr = new Operand((AbstractInsnNode)insn, (Value)this.getOrCreateLocal(insn.var), this);
        merging.mergeOutput(opr);
        if (dword) {
            this.operandStack.pushDual(opr);
        } else {
            this.operandStack.push(opr);
        }
    }

    private void convertVarStoreInsn(@Nonnull VarInsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 55 || op == 57;
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)insn);
        Operand opr = dword ? this.operandStack.popDual() : this.operandStack.pop();
        merging.mergeInputs(opr);
        JavaLocal local = this.getOrCreateLocal(insn.var);
        if (opr.stackLocal == null || opr.stackLocal == local) {
            JAssignStmt as = Jimple.newAssignStmt((LValue)local, (Value)opr.value, (StmtPositionInfo)this.getStmtPositionInfo());
            opr.stackLocal = local;
            this.setStmt(opr.insn, (Stmt)as);
        } else {
            JAssignStmt as = Jimple.newAssignStmt((LValue)local, (Value)opr.toImmediate(), (StmtPositionInfo)this.getStmtPositionInfo());
            this.setStmt((AbstractInsnNode)insn, (Stmt)as);
        }
        this.addReadOperandAssignments((Local)local);
    }

    private void convertVarInsn(@Nonnull VarInsnNode insn) {
        int op = insn.getOpcode();
        if (op >= 21 && op <= 25) {
            this.convertVarLoadInsn(insn);
        } else if (op >= 54 && op <= 58) {
            this.convertVarStoreInsn(insn);
        } else if (op == 169) {
            this.setStmt((AbstractInsnNode)insn, (Stmt)Jimple.newRetStmt((Immediate)this.getOrCreateLocal(insn.var), (StmtPositionInfo)this.getStmtPositionInfo()));
        } else {
            throw new UnsupportedOperationException("Unknown var op: " + op);
        }
    }

    private void convertLabel(@Nonnull LabelNode ln) {
        if (this.startTrapHandler.containsKey(ln)) {
            this.activeTrapHandlers.add(this.startTrapHandler.get(ln));
        }
        if (this.endTrapHandler.containsKey(ln)) {
            this.activeTrapHandlers.remove(this.endTrapHandler.get(ln));
        }
        if (!this.trapHandler.containsKey(ln)) {
            return;
        }
        if (this.inlineExceptionLabels.contains(ln)) {
            if (!this.insnToStmt.containsKey(ln)) {
                JNopStmt nop = Jimple.newNopStmt((StmtPositionInfo)this.getStmtPositionInfo());
                this.setStmt((AbstractInsnNode)ln, (Stmt)nop);
            }
            return;
        }
        OperandMerging merging = this.operandStack.getOrCreateMerging((AbstractInsnNode)ln);
        JCaughtExceptionRef ref = JavaJimple.getInstance().newCaughtExceptionRef();
        Operand opr = new Operand((AbstractInsnNode)ln, (Value)ref, this);
        merging.mergeOutput(opr);
        if (opr.stackLocal == null) {
            opr.stackLocal = this.newStackLocal();
        }
        JIdentityStmt as = Jimple.newIdentityStmt((Local)opr.stackLocal, (IdentityRef)ref, (StmtPositionInfo)this.getStmtPositionInfo());
        this.setStmt((AbstractInsnNode)ln, (Stmt)as);
        this.operandStack.push(opr);
    }

    private void convertLine(@Nonnull LineNumberNode ln) {
        this.currentLineNumber = ln.line;
        if (this.currentLineNumber > this.maxLineNumber) {
            this.maxLineNumber = this.currentLineNumber;
        }
    }

    private void addEdges(@Nonnull Table<AbstractInsnNode, AbstractInsnNode, BranchedInsnInfo> edges, @Nonnull ArrayDeque<BranchedInsnInfo> conversionWorklist, @Nonnull AbstractInsnNode branchingInsn, @Nonnull AbstractInsnNode tgt, @Nonnull List<LabelNode> tgts) {
        Object[] stackss = this.operandStack.getStack().toArray(new Operand[0]);
        int i = 0;
        int lastIdx = tgts.size();
        block0: do {
            BranchedInsnInfo edge;
            if ((edge = (BranchedInsnInfo)edges.get((Object)branchingInsn, (Object)tgt)) == null) {
                edge = new BranchedInsnInfo(tgt, this.operandStack.getStack(), this.currentLineNumber, this.activeTrapHandlers);
                edge.addToPrevStack((Operand[])stackss);
                edges.put((Object)branchingInsn, (Object)tgt, (Object)edge);
                conversionWorklist.add(edge);
                continue;
            }
            for (List<Operand> stackTemp : edge.getOperandStacks()) {
                int n;
                if (stackTemp.size() != stackss.length) continue;
                for (n = 0; n < stackss.length && stackTemp.get(n).equivTo((Operand)stackss[n]); ++n) {
                }
                if (n != stackss.length) continue;
                continue block0;
            }
            LinkedList<Operand[]> prevStacks = edge.getPrevStacks();
            for (Object[] objectArray : prevStacks) {
                if (!Arrays.equals(objectArray, stackss)) continue;
                continue block0;
            }
            edge.addOperandStack(this.operandStack.getStack());
            edge.addToPrevStack((Operand[])stackss);
            conversionWorklist.add(edge);
        } while (i < lastIdx && (tgt = (AbstractInsnNode)tgts.get(i++)) != null);
    }

    private void convert() {
        ArrayDeque<BranchedInsnInfo> worklist = new ArrayDeque<BranchedInsnInfo>();
        this.indexInlineExceptionHandlers();
        for (LabelNode handlerNode : this.trapHandler.keySet()) {
            if (this.inlineExceptionLabels.contains(handlerNode)) {
                JCaughtExceptionRef ref = JavaJimple.getInstance().newCaughtExceptionRef();
                Local local = this.newStackLocal();
                JIdentityStmt as = Jimple.newIdentityStmt((Local)local, (IdentityRef)ref, (StmtPositionInfo)this.getStmtPositionInfo());
                Operand opr = new Operand((AbstractInsnNode)handlerNode, (Value)ref, this);
                opr.stackLocal = local;
                worklist.add(new BranchedInsnInfo((AbstractInsnNode)handlerNode, Collections.singletonList(opr), this.currentLineNumber, this.activeTrapHandlers));
                this.inlineExceptionHandlers.put(handlerNode, as);
                continue;
            }
            worklist.add(new BranchedInsnInfo((AbstractInsnNode)handlerNode, new ArrayList<Operand>(), this.currentLineNumber, this.activeTrapHandlers));
        }
        worklist.add(new BranchedInsnInfo(this.instructions.getFirst(), Collections.emptyList(), this.currentLineNumber, this.activeTrapHandlers));
        HashBasedTable edges = HashBasedTable.create((int)1, (int)1);
        block1: do {
            BranchedInsnInfo edge = (BranchedInsnInfo)worklist.pollLast();
            AbstractInsnNode insn = edge.getInsn();
            this.currentLineNumber = edge.getLineNumber();
            this.operandStack.setOperandStack(new ArrayList<Operand>((Collection)edge.getOperandStacks().get(edge.getOperandStacks().size() - 1)));
            this.activeTrapHandlers = edge.getActiveTrapHandlers();
            do {
                int type;
                if ((type = insn.getType()) == 4) {
                    this.convertFieldInsn((FieldInsnNode)insn);
                    continue;
                }
                if (type == 10) {
                    this.convertIincInsn((IincInsnNode)insn);
                    continue;
                }
                if (type == 0) {
                    this.convertInsn((InsnNode)insn);
                    int op = insn.getOpcode();
                    if ((op < 172 || op > 177) && op != 191) continue;
                    continue block1;
                }
                if (type == 1) {
                    this.convertIntInsn((IntInsnNode)insn);
                    continue;
                }
                if (type == 9) {
                    this.convertLdcInsn((LdcInsnNode)insn);
                    continue;
                }
                if (type == 7) {
                    JumpInsnNode jmp = (JumpInsnNode)insn;
                    this.convertJumpInsn(jmp);
                    int op = jmp.getOpcode();
                    if (op == 168) {
                        throw new UnsupportedOperationException("JSR!");
                    }
                    if (op != 167) {
                        AbstractInsnNode next = insn.getNext();
                        this.addEdges((Table<AbstractInsnNode, AbstractInsnNode, BranchedInsnInfo>)edges, worklist, insn, next, Collections.singletonList(jmp.label));
                        continue block1;
                    }
                    this.addEdges((Table<AbstractInsnNode, AbstractInsnNode, BranchedInsnInfo>)edges, worklist, insn, (AbstractInsnNode)jmp.label, Collections.emptyList());
                    continue block1;
                }
                if (type == 12) {
                    LookupSwitchInsnNode swtch = (LookupSwitchInsnNode)insn;
                    this.convertLookupSwitchInsn(swtch);
                    LabelNode dflt = swtch.dflt;
                    this.addEdges((Table<AbstractInsnNode, AbstractInsnNode, BranchedInsnInfo>)edges, worklist, insn, (AbstractInsnNode)dflt, swtch.labels);
                    continue block1;
                }
                if (type == 5) {
                    this.convertMethodInsn((MethodInsnNode)insn);
                    continue;
                }
                if (type == 6) {
                    this.convertInvokeDynamicInsn((InvokeDynamicInsnNode)insn);
                    continue;
                }
                if (type == 13) {
                    this.convertMultiANewArrayInsn((MultiANewArrayInsnNode)insn);
                    continue;
                }
                if (type == 11) {
                    TableSwitchInsnNode swtch = (TableSwitchInsnNode)insn;
                    this.convertTableSwitchInsn(swtch);
                    LabelNode dflt = swtch.dflt;
                    this.addEdges((Table<AbstractInsnNode, AbstractInsnNode, BranchedInsnInfo>)edges, worklist, insn, (AbstractInsnNode)dflt, swtch.labels);
                    continue block1;
                }
                if (type == 3) {
                    this.convertTypeInsn((TypeInsnNode)insn);
                    continue;
                }
                if (type == 2) {
                    if (insn.getOpcode() == 169) {
                        throw new UnsupportedOperationException("RET!");
                    }
                    this.convertVarInsn((VarInsnNode)insn);
                    continue;
                }
                if (type == 8) {
                    this.convertLabel((LabelNode)insn);
                    continue;
                }
                if (type == 15) {
                    this.convertLine((LineNumberNode)insn);
                    continue;
                }
                if (type == 14) continue;
                throw new RuntimeException("Unknown instruction type: " + type);
            } while ((insn = insn.getNext()) != null);
        } while (!worklist.isEmpty());
    }

    private void indexInlineExceptionHandlers() {
        Set<LabelNode> handlerLabelNodes = this.trapHandler.keySet();
        if (handlerLabelNodes.isEmpty()) {
            return;
        }
        block0: for (AbstractInsnNode node : this.instructions) {
            if (node instanceof JumpInsnNode) {
                LabelNode handlerLabel = ((JumpInsnNode)node).label;
                if (!handlerLabelNodes.contains(handlerLabel)) continue;
                this.inlineExceptionLabels.add(handlerLabel);
                continue;
            }
            if (node instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)node;
                if (handlerLabelNodes.contains(lookupSwitchInsnNode.dflt)) {
                    this.inlineExceptionLabels.add(lookupSwitchInsnNode.dflt);
                    continue;
                }
                for (LabelNode l : lookupSwitchInsnNode.labels) {
                    if (!handlerLabelNodes.contains(l)) continue;
                    this.inlineExceptionLabels.add(l);
                    continue block0;
                }
                continue;
            }
            if (!(node instanceof TableSwitchInsnNode)) continue;
            TableSwitchInsnNode tableSwitchInsnNode = (TableSwitchInsnNode)node;
            if (handlerLabelNodes.contains(tableSwitchInsnNode.dflt)) {
                this.inlineExceptionLabels.add(tableSwitchInsnNode.dflt);
                continue;
            }
            for (LabelNode l : tableSwitchInsnNode.labels) {
                if (!handlerLabelNodes.contains(l)) continue;
                this.inlineExceptionLabels.add(l);
                continue block0;
            }
        }
    }

    public static LineNumberNode findLineInfo(@Nonnull InsnList insnList, @Nonnull AbstractInsnNode insnNode) {
        int idx = insnList.indexOf(insnNode);
        if (idx < 0) {
            return null;
        }
        ListIterator insnIt = insnList.iterator(idx);
        while (insnIt.hasPrevious()) {
            AbstractInsnNode node = (AbstractInsnNode)insnIt.previous();
            if (!(node instanceof LineNumberNode)) continue;
            return (LineNumberNode)node;
        }
        return null;
    }

    @Nonnull
    private StmtPositionInfo getFirstLineOfMethod() {
        for (AbstractInsnNode node : this.instructions) {
            if (!(node instanceof LineNumberNode)) continue;
            return new SimpleStmtPositionInfo(((LineNumberNode)node).line);
        }
        return StmtPositionInfo.getNoStmtPositionInfo();
    }

    @Nonnull
    private List<Stmt> buildPreambleLocals(Body.BodyBuilder bodyBuilder) {
        ArrayList<Stmt> preambleBlock = new ArrayList<Stmt>();
        MethodSignature methodSignature = this.lazyMethodSignature.get();
        StmtPositionInfo methodPosInfo = this.getFirstLineOfMethod();
        int localIdx = 0;
        if (!bodyBuilder.getModifiers().contains(MethodModifier.STATIC)) {
            JavaLocal thisLocal = JavaJimple.newLocal((String)this.determineLocalName(localIdx), (Type)this.declaringClass);
            this.locals.set(localIdx++, thisLocal);
            JIdentityStmt stmt = Jimple.newIdentityStmt((Local)thisLocal, (IdentityRef)Jimple.newThisRef((ClassType)this.declaringClass), (StmtPositionInfo)methodPosInfo);
            preambleBlock.add((Stmt)stmt);
        }
        for (int i = 0; i < methodSignature.getParameterTypes().size(); ++i) {
            Type parameterType = (Type)methodSignature.getParameterTypes().get(i);
            JavaLocal local = JavaJimple.newLocal((String)this.determineLocalName(localIdx), (Type)parameterType, AsmUtil.createAnnotationUsage(this.invisibleParameterAnnotations == null ? null : this.invisibleParameterAnnotations[i]));
            this.locals.set(localIdx, local);
            JIdentityStmt stmt = Jimple.newIdentityStmt((Local)local, (IdentityRef)Jimple.newParameterRef((Type)parameterType, (int)i), (StmtPositionInfo)methodPosInfo);
            preambleBlock.add((Stmt)stmt);
            if (AsmUtil.isDWord(parameterType)) {
                localIdx += 2;
                continue;
            }
            ++localIdx;
        }
        return preambleBlock;
    }

    private List<Trap> buildTraps() {
        ArrayList<Trap> traps = new ArrayList<Trap>();
        for (TryCatchBlockNode trycatch : this.tryCatchBlocks) {
            Stmt handler = this.trapHandler.get(trycatch.handler);
            if (handler == null) {
                throw new IllegalStateException("Label for the TrapHandler " + trycatch.handler + " has no associated Stmt to jump to.");
            }
            String exceptionName = trycatch.type != null ? AsmUtil.toQualifiedName(trycatch.type) : "java.lang.Throwable";
            JavaClassType exceptionType = this.identifierFactory.getClassType(exceptionName);
            Trap trap = Jimple.newTrap((ClassType)exceptionType, (Stmt)this.labelsToStmt.get(trycatch.start), (Stmt)this.labelsToStmt.get(trycatch.end), (Stmt)handler);
            traps.add(trap);
        }
        return traps;
    }

    private void arrangeStmts(MutableBlockStmtGraph graph, List<Stmt> stmtList, Body.BodyBuilder builder) {
        AbstractInsnNode insn = this.instructions.getFirst();
        ArrayDeque<LabelNode> danglingLabel = new ArrayDeque<LabelNode>();
        HashMap currentTraps = new HashMap();
        do {
            Object stmt;
            boolean isLabelNode;
            if (isLabelNode = insn instanceof LabelNode) {
                danglingLabel.add((LabelNode)insn);
            }
            if ((stmt = this.insnToStmt.get(insn)) == null) continue;
            if (!danglingLabel.isEmpty()) {
                Stmt stmt2 = stmt;
                danglingLabel.forEach(l -> this.labelsToStmt.put((LabelNode)l, targetStmt));
                if (isLabelNode) {
                    JIdentityStmt identityRef;
                    JIdentityStmt jIdentityStmt = identityRef = stmt instanceof JIdentityStmt ? (JIdentityStmt)stmt : null;
                    if (identityRef != null && identityRef.getRightOp() instanceof JCaughtExceptionRef) {
                        danglingLabel.forEach(label -> this.trapHandler.put((LabelNode)label, (Stmt)identityRef));
                    }
                }
                danglingLabel.clear();
            }
            this.emitStmt((Stmt)stmt, stmtList);
        } while ((insn = insn.getNext()) != null);
        HashMap branchingMap = new HashMap();
        for (Map.Entry entry : this.stmtsThatBranchToLabel.asMap().entrySet()) {
            BranchingStmt fromStmt = (BranchingStmt)entry.getKey();
            ArrayList<Stmt> targets = new ArrayList<Stmt>();
            for (LabelNode labelNode : (Collection)entry.getValue()) {
                Stmt targetStmt = this.labelsToStmt.get(labelNode);
                if (targetStmt == null) {
                    throw new IllegalStateException("targetStmt not found for fromStmt" + fromStmt + " " + entry.getValue() + " in method " + this.lazyMethodSignature.get());
                }
                targets.add(targetStmt);
            }
            branchingMap.put(fromStmt, targets);
        }
        List<Trap> traps = this.buildTraps();
        graph.initializeWith(stmtList, branchingMap, traps);
        for (Map.Entry<LabelNode, JIdentityStmt> entry : this.inlineExceptionHandlers.entrySet()) {
            JIdentityStmt handlerStmt = entry.getValue();
            this.emitStmt((Stmt)handlerStmt, stmtList);
            this.trapHandler.put(entry.getKey(), (Stmt)handlerStmt);
            JGotoStmt gotoStmt = Jimple.newGotoStmt((StmtPositionInfo)handlerStmt.getPositionInfo());
            stmtList.add((Stmt)gotoStmt);
            graph.addBlock(stmtList, currentTraps);
            stmtList.clear();
            Stmt targetStmt = this.insnToStmt.get(entry.getKey());
            graph.putEdge((BranchingStmt)gotoStmt, 0, targetStmt);
        }
    }

    private void emitStmt(@Nonnull Stmt handlerStmt, @Nonnull List<Stmt> block) {
        block.add(handlerStmt);
    }

    @Nonnull
    Stmt getLatestVersionOfStmt(@Nonnull Stmt oldStmt) {
        Stmt replacedVersion;
        while ((replacedVersion = this.replacedStmt.get(oldStmt)) != null) {
            oldStmt = replacedVersion;
        }
        return oldStmt;
    }

    void replaceStmt(@Nonnull Stmt oldStmt, Stmt newStmt) {
        if (oldStmt == newStmt) {
            return;
        }
        AbstractInsnNode key = null;
        for (Map.Entry<AbstractInsnNode, Stmt> entry : this.insnToStmt.entrySet()) {
            if (!Objects.equals(oldStmt, entry.getValue())) continue;
            key = entry.getKey();
        }
        if (key == null) {
            return;
        }
        if (newStmt == null) {
            this.insnToStmt.remove(key);
            return;
        }
        this.insnToStmt.put(key, newStmt);
        this.replacedStmt.put(oldStmt, newStmt);
        if (oldStmt instanceof BranchingStmt) {
            BranchingStmt branchingStmt = (BranchingStmt)oldStmt;
            List branchLabels = this.stmtsThatBranchToLabel.get((Object)branchingStmt);
            branchLabels.forEach(bl -> this.stmtsThatBranchToLabel.put((Object)((BranchingStmt)newStmt), bl));
            this.stmtsThatBranchToLabel.removeAll((Object)branchingStmt);
        }
    }

    public Stream<Stmt> getStmtsThatUse(@Nonnull Value value) {
        Stream<Stmt> currentUses = this.insnToStmt.values().stream().filter(stmt -> stmt.getUses().contains(value));
        Stream<Stmt> oldMappedUses = this.replacedStmt.entrySet().stream().filter(stmt -> ((Stmt)stmt.getKey()).getUses().contains(value)).map(stmt -> this.getLatestVersionOfStmt((Stmt)stmt.getValue()));
        return Stream.concat(currentUses, oldMappedUses);
    }
}

