/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.jimple.basic.Local;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.Operand;

final class OperandMerging {
    @Nullable
    private Operand output;
    @Nonnull
    final ArrayList<Operand[]> inputOperands = new ArrayList(1);
    @Nonnull
    private final AsmMethodSource src;

    OperandMerging(@Nonnull AsmMethodSource src) {
        this.src = src;
    }

    void mergeOutput(@Nonnull Operand outputOperand) {
        if (this.output == null) {
            this.output = outputOperand;
        } else if (this.output.stackLocal != null) {
            if (outputOperand.stackLocal == null) {
                outputOperand.changeStackLocal(this.output.stackLocal);
            } else if (this.output.stackLocal != outputOperand.stackLocal) {
                throw new IllegalStateException("Incompatible stacklocal mismatch. There exist multiple, different possible output Locals (" + outputOperand.stackLocal + ", " + this.output.stackLocal + ").");
            }
        }
    }

    void mergeInputs(Operand ... oprs) {
        if (this.inputOperands.isEmpty()) {
            this.inputOperands.add(oprs);
            return;
        }
        if (this.inputOperands.get(0).length != oprs.length) {
            throw new IllegalArgumentException("Invalid in operands length!");
        }
        if (oprs.length == 0) {
            return;
        }
        for (int i = 0; i < oprs.length; ++i) {
            int j;
            Operand newOp = oprs[i];
            Local stack = null;
            for (j = 0; j != this.inputOperands.size() && (stack = this.inputOperands.get((int)j)[i].stackLocal) == null; ++j) {
            }
            if (stack == null && newOp.stackLocal != null) {
                stack = newOp.stackLocal;
            }
            if (stack == null && this.inputOperands.get((int)0)[i].value.equivTo((Object)newOp.value)) continue;
            if (stack == null) {
                stack = this.src.newStackLocal();
            }
            for (j = 0; j != this.inputOperands.size(); ++j) {
                Operand prevOp = this.inputOperands.get(j)[i];
                prevOp.changeStackLocal(stack);
            }
            newOp.changeStackLocal(stack);
        }
        this.inputOperands.add(oprs);
    }
}

