/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import sootup.core.types.Type;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.bytecode.frontend.Operand;
import sootup.java.bytecode.frontend.OperandMerging;

public class OperandStack {
    @Nonnull
    private final AsmMethodSource methodSource;
    private List<Operand> stack;
    @Nonnull
    public Map<AbstractInsnNode, OperandMerging> mergings;

    public OperandStack(@Nonnull AsmMethodSource methodSource, int nrInsn) {
        this.methodSource = methodSource;
        this.mergings = new LinkedHashMap<AbstractInsnNode, OperandMerging>(nrInsn);
    }

    @Nonnull
    public OperandMerging getOrCreateMerging(@Nonnull AbstractInsnNode insn) {
        OperandMerging merging = this.mergings.get(insn);
        if (merging == null) {
            merging = new OperandMerging(this.methodSource);
            this.mergings.put(insn, merging);
        }
        return merging;
    }

    public void push(@Nonnull Operand opr) {
        this.stack.add(opr);
    }

    public void pushDual(@Nonnull Operand opr) {
        this.stack.add(Operand.DWORD_DUMMY);
        this.stack.add(opr);
    }

    @Nonnull
    public Operand peek() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Stack underrun");
        }
        return this.stack.get(this.stack.size() - 1);
    }

    public void push(@Nonnull Type t, @Nonnull Operand opr) {
        if (AsmUtil.isDWord(t)) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    @Nonnull
    public Operand pop() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Stack underrun");
        }
        return this.stack.remove(this.stack.size() - 1);
    }

    @Nonnull
    public Operand popDual() {
        Operand o = this.pop();
        Operand o2 = this.pop();
        if (o2 != Operand.DWORD_DUMMY && o2 != o) {
            throw new AssertionError((Object)("Not dummy operand, " + o2.value + " -- " + o.value));
        }
        return o;
    }

    @Nonnull
    public Operand pop(@Nonnull Type t) {
        return AsmUtil.isDWord(t) ? this.popDual() : this.pop();
    }

    @Nonnull
    public Operand popStackConst() {
        return this.pop();
    }

    @Nonnull
    public Operand popStackConstDual() {
        return this.popDual();
    }

    @Nonnull
    public List<Operand> getStack() {
        return this.stack;
    }

    public void setOperandStack(@Nonnull List<Operand> stack) {
        this.stack = stack;
    }
}

