/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.util.PathUtils;
import sootup.core.util.StreamUtils;
import sootup.core.views.View;
import sootup.java.bytecode.inputlocation.PathBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;

public class JavaClassPathAnalysisInputLocation
implements AnalysisInputLocation {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(JavaClassPathAnalysisInputLocation.class);
    @Nonnull
    private static final String WILDCARD_CHAR = "*";
    @Nonnull
    private final Collection<AnalysisInputLocation> cpEntries;
    private final SourceType srcType;
    private final List<BodyInterceptor> bodyInterceptors;

    public JavaClassPathAnalysisInputLocation(@Nonnull String classPath) {
        this(classPath, SourceType.Application);
    }

    public JavaClassPathAnalysisInputLocation(@Nonnull String classPath, @Nonnull SourceType srcType) {
        this(classPath, srcType, Collections.emptyList());
    }

    public JavaClassPathAnalysisInputLocation(@Nonnull String classPath, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this.srcType = srcType;
        this.bodyInterceptors = bodyInterceptors;
        if (classPath.length() <= 0) {
            throw new IllegalArgumentException("Empty class path given");
        }
        this.cpEntries = this.explodeClassPath(classPath);
        if (this.cpEntries.isEmpty()) {
            throw new IllegalArgumentException("Empty class path is given.");
        }
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.srcType;
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    @Nonnull
    static Stream<Path> explode(@Nonnull String paths, FileSystem fileSystem) {
        String regex = "(?<!\\\\)" + Pattern.quote(File.pathSeparator);
        Stream<Path> exploded = Stream.of(paths.split(regex)).flatMap(e -> JavaClassPathAnalysisInputLocation.handleWildCards(e, fileSystem));
        return exploded.map(Path::normalize).distinct();
    }

    @Nonnull
    static Stream<Path> explode(@Nonnull String paths) {
        return JavaClassPathAnalysisInputLocation.explode(paths, FileSystems.getDefault());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static Stream<Path> handleWildCards(@Nonnull String entry, FileSystem fileSystem) {
        if (!entry.endsWith(WILDCARD_CHAR)) return Stream.of(fileSystem.getPath(entry, new String[0]));
        Path baseDir = fileSystem.getPath(entry.substring(0, entry.indexOf(WILDCARD_CHAR)), new String[0]);
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(baseDir, "*.{jar,JAR}");){
            Stream stream = StreamUtils.iteratorToStream(paths.iterator());
            return stream;
        }
        catch (NotDirectoryException | PatternSyntaxException e) {
            throw new IllegalStateException("Malformed wildcard entry", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't access entries denoted by wildcard", e);
        }
    }

    @Nonnull
    private static Stream<Path> handleWildCards(@Nonnull String entry) {
        return JavaClassPathAnalysisInputLocation.handleWildCards(entry, FileSystems.getDefault());
    }

    @Nonnull
    public Collection<JavaSootClassSource> getClassSources(@Nonnull View view) {
        HashSet found = new HashSet();
        for (AnalysisInputLocation inputLocation : this.cpEntries) {
            found.addAll(inputLocation.getClassSources(view));
        }
        return found.stream().map(src -> (JavaSootClassSource)src).collect(Collectors.toList());
    }

    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        for (AnalysisInputLocation inputLocation : this.cpEntries) {
            Optional classSource = inputLocation.getClassSource(type, view);
            if (!classSource.isPresent()) continue;
            return classSource.map(src -> (JavaSootClassSource)src);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<AnalysisInputLocation> inputLocationForPath(@Nonnull Path path) {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || PathUtils.isArchive((Path)path))) {
            return Optional.of(PathBasedAnalysisInputLocation.create(path, this.srcType, this.bodyInterceptors));
        }
        logger.warn("Invalid/Unknown class path entry: " + path);
        return Optional.empty();
    }

    private List<AnalysisInputLocation> explodeClassPath(@Nonnull String jarPath) {
        return this.explodeClassPath(jarPath, FileSystems.getDefault());
    }

    private List<AnalysisInputLocation> explodeClassPath(@Nonnull String jarPath, @Nonnull FileSystem fileSystem) {
        return JavaClassPathAnalysisInputLocation.explode(jarPath, fileSystem).flatMap(cp -> StreamUtils.optionalToStream(this.inputLocationForPath((Path)cp))).collect(Collectors.toList());
    }

    public int hashCode() {
        return this.cpEntries.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaClassPathAnalysisInputLocation)) {
            return false;
        }
        return this.cpEntries.equals(((JavaClassPathAnalysisInputLocation)o).cpEntries);
    }
}

