/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.util.PathUtils;
import sootup.java.bytecode.frontend.AsmModuleSource;
import sootup.java.bytecode.inputlocation.JavaClassPathAnalysisInputLocation;
import sootup.java.bytecode.inputlocation.PathBasedAnalysisInputLocation;
import sootup.java.core.JavaModuleIdentifierFactory;
import sootup.java.core.JavaModuleInfo;
import sootup.java.core.signatures.ModuleSignature;

public class ModuleFinder {
    @Nonnull
    private final Map<ModuleSignature, AnalysisInputLocation> moduleInputLocation = new HashMap<ModuleSignature, AnalysisInputLocation>();
    @Nonnull
    private final Map<ModuleSignature, JavaModuleInfo> moduleInfoMap = new HashMap<ModuleSignature, JavaModuleInfo>();
    private int next = 0;
    @Nonnull
    private final List<Path> modulePathEntries;
    private final SourceType sourceType;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;

    public boolean hasMoreToResolve() {
        return this.next < this.modulePathEntries.size();
    }

    public ModuleFinder(@Nonnull Path modulePath, @Nonnull FileSystem fileSystem, @Nonnull SourceType sourceType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this.sourceType = sourceType;
        this.bodyInterceptors = bodyInterceptors;
        this.modulePathEntries = JavaClassPathAnalysisInputLocation.explode(modulePath.toString(), fileSystem).collect(Collectors.toList());
        for (Path modulePathEntry : this.modulePathEntries) {
            if (Files.exists(modulePathEntry, new LinkOption[0])) continue;
            throw new IllegalArgumentException("'" + modulePathEntry + "' from modulePath '" + modulePath + "' does not exist in the filesystem.");
        }
    }

    public ModuleFinder(@Nonnull Path modulePath, @Nonnull SourceType sourceType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this(modulePath, FileSystems.getDefault(), sourceType, bodyInterceptors);
    }

    public ModuleFinder(@Nonnull Path modulePath) {
        this(modulePath, FileSystems.getDefault(), SourceType.Application, Collections.emptyList());
    }

    @Nonnull
    public Optional<JavaModuleInfo> getModuleInfo(ModuleSignature sig) {
        if (this.hasMoreToResolve()) {
            this.getAllModules();
        }
        return Optional.ofNullable(this.moduleInfoMap.get(sig));
    }

    @Nonnull
    public Set<ModuleSignature> getModules() {
        if (this.hasMoreToResolve()) {
            this.getAllModules();
        }
        return Collections.unmodifiableSet(this.moduleInfoMap.keySet());
    }

    @Nullable
    public AnalysisInputLocation getModule(@Nonnull ModuleSignature moduleName) {
        AnalysisInputLocation inputLocationForModule = this.moduleInputLocation.get(moduleName);
        if (inputLocationForModule != null) {
            return inputLocationForModule;
        }
        while (this.hasMoreToResolve()) {
            this.discoverModulesIn(this.modulePathEntries.get(this.next++));
            inputLocationForModule = this.moduleInputLocation.get(moduleName);
            if (inputLocationForModule == null) continue;
            return inputLocationForModule;
        }
        return null;
    }

    @Nonnull
    public Collection<ModuleSignature> getAllModules() {
        while (this.hasMoreToResolve()) {
            this.discoverModulesIn(this.modulePathEntries.get(this.next++));
        }
        return Collections.unmodifiableCollection(this.moduleInputLocation.keySet());
    }

    private void discoverModulesIn(@Nonnull Path path) {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ResolveException("Error while discovering modules", path, (Exception)e);
        }
        if (PathUtils.isArchive((Path)path)) {
            this.buildModuleForJar(path);
        } else if (attrs.isDirectory()) {
            Path mi = path.resolve("module-info.class");
            if (Files.exists(mi, new LinkOption[0])) {
                this.buildModuleForExplodedModule(path);
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path entry : stream) {
                    try {
                        attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                    }
                    catch (NoSuchFileException ignore) {
                        continue;
                    }
                    if (attrs.isDirectory()) {
                        mi = entry.resolve("module-info.class");
                        if (!Files.exists(mi, new LinkOption[0])) continue;
                        this.buildModuleForExplodedModule(entry);
                        continue;
                    }
                    if (!PathUtils.isArchive((Path)entry)) continue;
                    this.buildModuleForJar(entry);
                }
            }
            catch (Exception e) {
                throw new ResolveException("Error while discovering modules", path, e);
            }
        }
    }

    private void buildModuleForExplodedModule(@Nonnull Path dir) throws ResolveException {
        PathBasedAnalysisInputLocation inputLocation = PathBasedAnalysisInputLocation.create(dir, this.sourceType, this.bodyInterceptors);
        Path moduleInfoFile = dir.resolve("module-info.class");
        if (!Files.exists(moduleInfoFile, new LinkOption[0]) && !Files.isRegularFile(moduleInfoFile, new LinkOption[0])) {
            return;
        }
        AsmModuleSource moduleInfo = new AsmModuleSource(moduleInfoFile);
        JavaModuleInfo oldValue = this.moduleInfoMap.put(moduleInfo.getModuleSignature(), moduleInfo);
        this.moduleInputLocation.put(moduleInfo.getModuleSignature(), inputLocation);
        if (oldValue != null) {
            throw new IllegalStateException(moduleInfo.getModuleSignature().toString() + " has multiple occurences.");
        }
    }

    private void buildModuleForJar(@Nonnull Path jar) {
        PathBasedAnalysisInputLocation inputLocation = PathBasedAnalysisInputLocation.create(jar, this.sourceType, this.bodyInterceptors);
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(jar, (ClassLoader)null);){
            Path archiveRoot = zipFileSystem.getPath("/", new String[0]);
            Path mi = archiveRoot.resolve("module-info.class");
            if (Files.exists(mi, new LinkOption[0])) {
                AsmModuleSource moduleInfo = new AsmModuleSource(mi);
                this.moduleInfoMap.put(moduleInfo.getModuleSignature(), moduleInfo);
                this.moduleInputLocation.put(moduleInfo.getModuleSignature(), inputLocation);
            } else {
                ModuleSignature moduleSignature = JavaModuleIdentifierFactory.getModuleSignature((String)ModuleFinder.createModuleNameForAutomaticModule(jar));
                this.moduleInputLocation.put(moduleSignature, inputLocation);
                this.moduleInfoMap.put(moduleSignature, JavaModuleInfo.createAutomaticModuleInfo((ModuleSignature)moduleSignature));
            }
        }
        catch (IOException e) {
            throw new ResolveException("Error resolving module descriptor in a Jar", jar, (Exception)e);
        }
    }

    @Nonnull
    public static String createModuleNameForAutomaticModule(@Nonnull Path path) {
        String moduleName;
        Matcher matcher;
        try {
            Manifest manifest;
            Attributes attr;
            String automaticModuleName;
            JarFile jar = new JarFile(path.toFile());
            String file = "META-INF/MANIFEST.MF";
            JarEntry entry = (JarEntry)jar.getEntry("META-INF/MANIFEST.MF");
            if (entry != null && (automaticModuleName = (attr = (manifest = new Manifest(jar.getInputStream(entry))).getMainAttributes()).getValue("Automatic-Module-Name")) != null) {
                return automaticModuleName;
            }
        }
        catch (IOException jar) {
            // empty catch block
        }
        String filename = path.getFileName().toString();
        int i = filename.lastIndexOf(File.separator);
        if (i != -1) {
            filename = filename.substring(i + 1);
        }
        if ((matcher = Patterns.VERSION.matcher(moduleName = filename.substring(0, filename.length() - 4))).find()) {
            int start = matcher.start();
            moduleName = moduleName.substring(0, start);
        }
        moduleName = Patterns.ALPHA_NUM.matcher(moduleName).replaceAll(".");
        int len = (moduleName = Patterns.REPEATING_DOTS.matcher(moduleName).replaceAll(".")).length();
        if (len > 0 && moduleName.charAt(0) == '.') {
            moduleName = Patterns.LEADING_DOTS.matcher(moduleName).replaceAll("");
        }
        if ((len = moduleName.length()) > 0 && moduleName.charAt(len - 1) == '.') {
            moduleName = Patterns.TRAILING_DOTS.matcher(moduleName).replaceAll("");
        }
        return moduleName;
    }

    public int hashCode() {
        return this.modulePathEntries.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModuleFinder)) {
            return false;
        }
        return this.modulePathEntries.equals(((ModuleFinder)o).modulePathEntries);
    }

    private static class Patterns {
        static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        static final Pattern ALPHA_NUM = Pattern.compile("[^A-Za-z0-9]");
        static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
        static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
        static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");

        private Patterns() {
        }
    }
}

