/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.inputlocation;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.core.Language;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.bytecode.inputlocation.ArchiveBasedAnalysisInputLocation;
import sootup.java.bytecode.inputlocation.PathBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;

public class MultiReleaseJarAnalysisInputLocation
extends ArchiveBasedAnalysisInputLocation {
    protected static final Integer DEFAULT_VERSION = 0;
    @Nonnull
    protected final Language language;
    @Nonnull
    private final List<BodyInterceptor> bodyInterceptors;
    @Nonnull
    protected final Map<Integer, AnalysisInputLocation> inputLocations = new LinkedHashMap<Integer, AnalysisInputLocation>();

    public static AnalysisInputLocation create(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull Language language, List<BodyInterceptor> bodyInterceptors) {
        if (MultiReleaseJarAnalysisInputLocation.isMultiReleaseJar(path)) {
            return new MultiReleaseJarAnalysisInputLocation(path, srcType, language, bodyInterceptors, true);
        }
        return PathBasedAnalysisInputLocation.create(path, srcType, bodyInterceptors, Collections.singletonList(Paths.get("/META-INF", new String[0])));
    }

    public MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nonnull Language language) {
        this(path, SourceType.Application, language);
    }

    public MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull Language language) {
        this(path, srcType, language, Collections.emptyList());
    }

    public MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull Language language, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this(path, srcType, language, bodyInterceptors, MultiReleaseJarAnalysisInputLocation.isMultiReleaseJar(path));
    }

    protected MultiReleaseJarAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull Language language, @Nonnull List<BodyInterceptor> bodyInterceptors, boolean isMultiRelease) {
        super(path, srcType);
        FileSystem fs;
        this.language = language;
        this.bodyInterceptors = bodyInterceptors;
        if (!isMultiRelease) {
            throw new IllegalArgumentException("The given path does not point to a multi release jar.");
        }
        try {
            fs = (FileSystem)fileSystemCache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Could not open filesystemcache.", e);
        }
        Path archiveRoot = fs.getPath("/", new String[0]);
        Path versionedRoot = archiveRoot.getFileSystem().getPath("/META-INF/versions/", new String[0]);
        try (Stream<Path> list = Files.list(versionedRoot);){
            list.map(dir -> {
                String versionDirName = dir.getFileName().toString();
                return versionDirName.substring(0, versionDirName.length() - 1);
            }).map(Integer::new).filter(version -> version <= language.getVersion()).sorted(Comparator.reverseOrder()).forEach(version -> {
                Path versionRoot = archiveRoot.getFileSystem().getPath("/META-INF", "versions", version.toString());
                this.inputLocations.put((Integer)version, PathBasedAnalysisInputLocation.create(versionRoot, this.sourceType, bodyInterceptors, Collections.emptyList()));
            });
            this.inputLocations.put(DEFAULT_VERSION, this.createAnalysisInputLocation(archiveRoot, srcType, this.getBodyInterceptors()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not index the given file.", e);
        }
    }

    protected AnalysisInputLocation createAnalysisInputLocation(Path archiveRoot, SourceType sourceType, List<BodyInterceptor> bodyInterceptors) {
        return PathBasedAnalysisInputLocation.create(archiveRoot, sourceType, bodyInterceptors, Collections.singletonList(Paths.get("/META-INF", new String[0])));
    }

    @Override
    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        for (AnalysisInputLocation analysisInputLocation : this.inputLocations.values()) {
            Optional classSource = analysisInputLocation.getClassSource(type, view);
            if (!classSource.isPresent()) continue;
            SootClassSource src = (SootClassSource)classSource.get();
            JavaSootClassSource javaSootClassSource = (JavaSootClassSource)src;
            return Optional.of(javaSootClassSource);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Collection<JavaSootClassSource> getClassSources(@Nonnull View view) {
        ArrayList<JavaSootClassSource> classSources = new ArrayList<JavaSootClassSource>();
        this.inputLocations.values().stream().flatMap(location -> location.getClassSources(view).stream()).map(src -> (JavaSootClassSource)src).forEach(cs -> {
            if (classSources.stream().noneMatch(bestMatchCS -> bestMatchCS.getClassType().getFullyQualifiedName().equals(cs.getClassType().getFullyQualifiedName()))) {
                classSources.add((JavaSootClassSource)cs);
            }
        });
        return classSources;
    }

    @Nonnull
    public Language getLanguage() {
        return this.language;
    }

    public static boolean isMultiReleaseJar(Path path) {
        try {
            FileInputStream inputStream = new FileInputStream(path.toFile());
            JarInputStream jarStream = new JarInputStream(inputStream);
            Manifest mf = jarStream.getManifest();
            if (mf == null) {
                return false;
            }
            Attributes attributes = mf.getMainAttributes();
            String value = attributes.getValue("Multi-Release");
            if (value == null) {
                return false;
            }
            return Boolean.parseBoolean(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Manifest file not found.", e);
        }
    }

    @Override
    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.bodyInterceptors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static List<Integer> getLanguageVersions(@Nonnull Path path) {
        FileSystem fs;
        try {
            fs = (FileSystem)fileSystemCache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Could not open filesystemcache.", e);
        }
        Path archiveRoot = fs.getPath("/", new String[0]);
        Path versionedRoot = archiveRoot.getFileSystem().getPath("/META-INF/versions/", new String[0]);
        try (Stream<Path> list = Files.list(versionedRoot);){
            List list2 = list.map(dir -> {
                String versionDirName = dir.getFileName().toString();
                return versionDirName.substring(0, versionDirName.length() - 1);
            }).map(Integer::new).sorted().collect(Collectors.toCollection(ArrayList::new));
            return list2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not index the given file.", e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiReleaseJarAnalysisInputLocation)) {
            return false;
        }
        return this.path.equals(((MultiReleaseJarAnalysisInputLocation)o).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

