/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ReplaceUseStmtVisitor;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.views.View;

public class Aggregator
implements BodyInterceptor {
    protected boolean dontAggregateFieldLocals;

    public Aggregator() {
        this(false);
    }

    public Aggregator(boolean dontAggregateFieldLocals) {
        this.dontAggregateFieldLocals = dontAggregateFieldLocals;
    }

    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph graph = builder.getStmtGraph();
        List stmts = builder.getStmts();
        Map usesMap = Body.collectUses((Collection)stmts);
        for (Stmt stmt : stmts) {
            JAssignStmt assignStmt;
            LValue lhs;
            if (!(stmt instanceof JAssignStmt) || !((lhs = (assignStmt = (JAssignStmt)stmt).getLeftOp()) instanceof Local)) continue;
            Local lhsLocal = (Local)lhs;
            if (this.dontAggregateFieldLocals && !lhsLocal.getName().startsWith("$")) continue;
            for (Value val : assignStmt.getUses()) {
                Stmt newStmt;
                List path;
                Stmt relevantDef;
                List defs;
                Collection usesOfVal;
                if (!(val instanceof Local) || (usesOfVal = (Collection)usesMap.get(val)).size() > 1 || (defs = ((Local)val).getDefs((Collection)stmts)).size() != 1 || !graph.containsNode(relevantDef = (Stmt)defs.get(0)) || !graph.containsNode(stmt) || (path = graph.getExtendedBasicBlockPathBetween(relevantDef, stmt)) == null) continue;
                boolean cantAggr = false;
                boolean propagatingInvokeExpr = false;
                boolean propagatingFieldRef = false;
                boolean propagatingArrayRef = false;
                ArrayList<JFieldRef> fieldRefList = new ArrayList<JFieldRef>();
                HashSet<Value> localsUsed = new HashSet<Value>();
                for (Stmt pathStmt : path) {
                    for (Value use : pathStmt.getUses()) {
                        if (use instanceof Local) {
                            localsUsed.add(use);
                            continue;
                        }
                        if (use instanceof AbstractInstanceInvokeExpr) {
                            propagatingInvokeExpr = true;
                            continue;
                        }
                        if (use instanceof JArrayRef) {
                            propagatingArrayRef = true;
                            continue;
                        }
                        if (!(use instanceof JFieldRef)) continue;
                        propagatingFieldRef = true;
                        fieldRefList.add((JFieldRef)use);
                    }
                }
                block6: for (Stmt pathStmt : path) {
                    if (pathStmt != stmt && pathStmt != relevantDef) {
                        block7: for (Value stmtDef : pathStmt.getDefs()) {
                            if (localsUsed.contains(stmtDef)) {
                                cantAggr = true;
                                break;
                            }
                            if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                            if (stmtDef instanceof JFieldRef) {
                                if (propagatingInvokeExpr) {
                                    cantAggr = true;
                                    break;
                                }
                                if (!propagatingFieldRef) continue;
                                for (JFieldRef fieldRef : fieldRefList) {
                                    if (!fieldRef.equals((JFieldRef)stmtDef)) continue;
                                    cantAggr = true;
                                    continue block7;
                                }
                                continue;
                            }
                            if (!(stmtDef instanceof JArrayRef) || !propagatingInvokeExpr && !propagatingArrayRef) continue;
                            cantAggr = true;
                            break;
                        }
                    }
                    if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                    for (Value value : stmt.getUses()) {
                        if (pathStmt == stmt && value == lhs) continue block6;
                        if (!(value instanceof AbstractInstanceInvokeExpr) && (!propagatingInvokeExpr || !(value instanceof JFieldRef) && !(value instanceof JArrayRef))) continue;
                        cantAggr = true;
                        continue block6;
                    }
                }
                if (cantAggr || !(relevantDef instanceof JAssignStmt)) continue;
                Value aggregatee = ((AbstractDefinitionStmt)relevantDef).getRightOp();
                ReplaceUseStmtVisitor replaceVisitor = new ReplaceUseStmtVisitor(val, aggregatee);
                try {
                    replaceVisitor.caseAssignStmt(assignStmt);
                    newStmt = (Stmt)replaceVisitor.getResult();
                }
                catch (ClassCastException iae) {
                    newStmt = null;
                }
                if (newStmt == null) continue;
                graph.replaceNode(stmt, newStmt);
                if (graph.getStartingStmt() == relevantDef) {
                    Stmt newStartingStmt = (Stmt)builder.getStmtGraph().successors(relevantDef).get(0);
                    graph.setStartingStmt(newStartingStmt);
                }
                graph.removeNode(relevantDef);
            }
        }
    }
}

