/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import javax.annotation.Nullable;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.ComparableConstant;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LogicalConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.constant.NumericConstant;
import sootup.core.jimple.common.constant.RealConstant;
import sootup.core.jimple.common.constant.ShiftableConstant;
import sootup.core.jimple.common.constant.StringConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractUnopExpr;
import sootup.core.jimple.common.expr.JAddExpr;
import sootup.core.jimple.common.expr.JAndExpr;
import sootup.core.jimple.common.expr.JCmpExpr;
import sootup.core.jimple.common.expr.JCmpgExpr;
import sootup.core.jimple.common.expr.JCmplExpr;
import sootup.core.jimple.common.expr.JDivExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JGeExpr;
import sootup.core.jimple.common.expr.JGtExpr;
import sootup.core.jimple.common.expr.JLeExpr;
import sootup.core.jimple.common.expr.JLtExpr;
import sootup.core.jimple.common.expr.JMulExpr;
import sootup.core.jimple.common.expr.JNeExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JOrExpr;
import sootup.core.jimple.common.expr.JRemExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JSubExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.expr.JXorExpr;

public class Evaluator {
    public static boolean isConstantValue(Value op) {
        if (op instanceof Constant) {
            return true;
        }
        if (op instanceof AbstractUnopExpr) {
            Immediate innerOp = ((AbstractUnopExpr)op).getOp();
            if (innerOp == NullConstant.getInstance()) {
                return false;
            }
            return Evaluator.isConstantValue((Value)innerOp);
        }
        if (op instanceof AbstractBinopExpr) {
            AbstractBinopExpr binExpr = (AbstractBinopExpr)op;
            Immediate op1 = binExpr.getOp1();
            Immediate op2 = binExpr.getOp2();
            boolean isOp1Constant = Evaluator.isConstantValue((Value)op1);
            boolean isOp2Constant = Evaluator.isConstantValue((Value)op2);
            if (op instanceof JDivExpr || op instanceof JRemExpr) {
                if (!isOp1Constant || !isOp2Constant) {
                    return false;
                }
                Constant c2 = Evaluator.getConstantValueOf((Value)op2);
                if (c2 instanceof IntConstant && ((IntConstant)c2).getValue() == 0) {
                    return false;
                }
                if (c2 instanceof LongConstant && ((LongConstant)c2).getValue() == 0L) {
                    return false;
                }
            }
            return isOp1Constant && isOp2Constant;
        }
        return false;
    }

    @Nullable
    public static Constant getConstantValueOf(Value op) {
        if (!Evaluator.isConstantValue(op)) {
            return null;
        }
        if (op instanceof Constant) {
            return (Constant)op;
        }
        if (op instanceof AbstractUnopExpr) {
            if (op instanceof JNegExpr) {
                Constant constant = Evaluator.getConstantValueOf((Value)((JNegExpr)op).getOp());
                return ((NumericConstant)constant).negate();
            }
        } else if (op instanceof AbstractBinopExpr) {
            AbstractBinopExpr binopExpr = (AbstractBinopExpr)op;
            Immediate op1 = binopExpr.getOp1();
            Immediate op2 = binopExpr.getOp2();
            Constant c1 = Evaluator.getConstantValueOf((Value)op1);
            Constant c2 = Evaluator.getConstantValueOf((Value)op2);
            if (op instanceof JAddExpr) {
                return ((NumericConstant)c1).add((NumericConstant)c2);
            }
            if (op instanceof JSubExpr) {
                return ((NumericConstant)c1).subtract((NumericConstant)c2);
            }
            if (op instanceof JMulExpr) {
                return ((NumericConstant)c1).multiply((NumericConstant)c2);
            }
            if (op instanceof JDivExpr) {
                return ((NumericConstant)c1).divide((NumericConstant)c2);
            }
            if (op instanceof JRemExpr) {
                return ((NumericConstant)c1).remainder((NumericConstant)c2);
            }
            if (op instanceof JEqExpr || op instanceof JNeExpr) {
                if (c1 instanceof NumericConstant) {
                    if (!(c2 instanceof NumericConstant)) {
                        return IntConstant.getInstance((int)0);
                    }
                    if (op instanceof JEqExpr) {
                        return ((NumericConstant)c1).equalEqual((ComparableConstant)((NumericConstant)c2));
                    }
                    return ((NumericConstant)c1).notEqual((ComparableConstant)((NumericConstant)c2));
                }
                if (c1 instanceof StringConstant || c1 instanceof NullConstant || c1 instanceof ClassConstant) {
                    boolean equality = c1.equals(c2);
                    boolean truth = op instanceof JEqExpr == equality;
                    return IntConstant.getInstance((int)(truth ? 1 : 0));
                }
                return null;
            }
            if (op instanceof JGtExpr) {
                return ((NumericConstant)c1).greaterThan((NumericConstant)c2);
            }
            if (op instanceof JGeExpr) {
                return ((NumericConstant)c1).greaterThanOrEqual((NumericConstant)c2);
            }
            if (op instanceof JLtExpr) {
                return ((NumericConstant)c1).lessThan((NumericConstant)c2);
            }
            if (op instanceof JLeExpr) {
                return ((NumericConstant)c1).lessThanOrEqual((NumericConstant)c2);
            }
            if (op instanceof JAndExpr) {
                return ((LogicalConstant)c1).and((LogicalConstant)c2);
            }
            if (op instanceof JOrExpr) {
                return ((LogicalConstant)c1).or((LogicalConstant)c2);
            }
            if (op instanceof JXorExpr) {
                return ((LogicalConstant)c1).xor((LogicalConstant)c2);
            }
            if (op instanceof JShlExpr) {
                return ((ShiftableConstant)c1).shiftLeft((IntConstant)c2);
            }
            if (op instanceof JShrExpr) {
                return ((ShiftableConstant)c1).shiftRight((IntConstant)c2);
            }
            if (op instanceof JUshrExpr) {
                return ((ShiftableConstant)c1).unsignedShiftRight((IntConstant)c2);
            }
            if (op instanceof JCmpExpr) {
                if (c1 instanceof LongConstant && c2 instanceof LongConstant) {
                    return ((LongConstant)c1).cmp((LongConstant)c2);
                }
                throw new IllegalArgumentException("CmpExpr: LongConstant(s) expected");
            }
            if (op instanceof JCmpgExpr || op instanceof JCmplExpr) {
                if (c1 instanceof RealConstant && c2 instanceof RealConstant) {
                    if (op instanceof JCmpgExpr) {
                        return ((RealConstant)c1).cmpg((RealConstant)c2);
                    }
                    return ((RealConstant)c1).cmpl((RealConstant)c2);
                }
                throw new IllegalArgumentException("CmpExpr: RealConstant(s) expected");
            }
            return null;
        }
        return null;
    }
}

