/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.IdentifierFactory;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.EnumConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.MethodHandle;
import sootup.core.jimple.common.constant.MethodType;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.constant.StringConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractFloatBinopExpr;
import sootup.core.jimple.common.expr.AbstractIntBinopExpr;
import sootup.core.jimple.common.expr.AbstractIntLongBinopExpr;
import sootup.core.jimple.common.expr.AbstractUnopExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.ref.Ref;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootClass;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.java.bytecode.interceptors.typeresolving.PrimitiveHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.Typing;
import sootup.java.bytecode.interceptors.typeresolving.types.AugmentIntegerTypes;
import sootup.java.bytecode.interceptors.typeresolving.types.BottomType;

public class AugEvalFunction {
    private final ImmutableSet<ClassType> evalClassTypes;
    private final ClassType stringClassType;
    private final ClassType classClassType;
    private final ClassType methodHandleClassType;
    private final ClassType methodTypeClassType;
    private final ClassType throwableClassType;
    View view;

    public AugEvalFunction(View view) {
        this.view = view;
        IdentifierFactory identifierFactory = view.getIdentifierFactory();
        this.evalClassTypes = ImmutableSet.of((Object)identifierFactory.getClassType("java.lang.Object"), (Object)identifierFactory.getClassType("java.lang.Cloneable"), (Object)identifierFactory.getClassType("java.io.Serializable"));
        this.stringClassType = identifierFactory.getClassType("java.lang.String");
        this.classClassType = identifierFactory.getClassType("java.lang.Class");
        this.methodHandleClassType = identifierFactory.getClassType("java.lang.MethodHandle");
        this.methodTypeClassType = identifierFactory.getClassType("java.lang.MethodType");
        this.throwableClassType = identifierFactory.getClassType("java.lang.Throwable");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Type evaluate(@Nonnull Typing typing, @Nonnull Value value, @Nonnull Stmt stmt, @Nonnull StmtGraph<?> graph) {
        if (value instanceof Immediate) {
            if (value instanceof Local) {
                return typing.getType((Local)value);
            }
            if (!(value instanceof Constant)) return null;
            if (value.getClass() == IntConstant.class) {
                int val = ((IntConstant)value).getValue();
                if (val >= 0 && val < 2) {
                    return AugmentIntegerTypes.getInteger1();
                }
                if (val >= 2 && val < 128) {
                    return AugmentIntegerTypes.getInteger127();
                }
                if (val >= -128 && val < 0) {
                    return PrimitiveType.getByte();
                }
                if (val >= 128 && val < 32768) {
                    return AugmentIntegerTypes.getInteger32767();
                }
                if (val >= Short.MIN_VALUE && val < -128) {
                    return PrimitiveType.getShort();
                }
                if (val < 32768 || val >= 65536) return PrimitiveType.getInt();
                return PrimitiveType.getChar();
            }
            if (value.getClass() == LongConstant.class || value.getClass() == FloatConstant.class || value.getClass() == DoubleConstant.class || value.getClass() == NullConstant.class || value.getClass() == EnumConstant.class) {
                return value.getType();
            }
            if (value.getClass() == StringConstant.class) {
                return this.stringClassType;
            }
            if (value.getClass() == ClassConstant.class) {
                return this.classClassType;
            }
            if (value.getClass() == MethodHandle.class) {
                return this.methodHandleClassType;
            }
            if (value.getClass() != MethodType.class) throw new IllegalStateException("can't evaluate this type of Constant '" + value + "'.");
            return this.methodTypeClassType;
        }
        if (value instanceof Expr) {
            if (value instanceof AbstractBinopExpr) {
                Type tl = this.evaluate(typing, (Value)((AbstractBinopExpr)value).getOp1(), stmt, graph);
                if (tl == null) {
                    return null;
                }
                Type tr = this.evaluate(typing, (Value)((AbstractBinopExpr)value).getOp2(), stmt, graph);
                if (tr == null) {
                    return null;
                }
                if (value instanceof AbstractIntBinopExpr) {
                    if (!(value instanceof AbstractConditionExpr)) return PrimitiveType.getByte();
                    return PrimitiveType.getBoolean();
                }
                if (value instanceof AbstractIntLongBinopExpr) {
                    if (value instanceof JShlExpr || value instanceof JShrExpr || value instanceof JUshrExpr) {
                        return tl instanceof PrimitiveType.IntType ? PrimitiveType.getInt() : tl;
                    }
                    if (!(tl instanceof PrimitiveType.IntType) || !(tr instanceof PrimitiveType.IntType)) return tl.getClass() == PrimitiveType.LongType.class ? PrimitiveType.getLong() : tr;
                    if (tl.getClass() == PrimitiveType.BooleanType.class) {
                        return tr.getClass() == PrimitiveType.BooleanType.class ? PrimitiveType.getBoolean() : tr;
                    }
                    if (tr.getClass() == PrimitiveType.BooleanType.class) {
                        return tl;
                    }
                    Collection<Type> lca = PrimitiveHierarchy.getLeastCommonAncestor(tl, tr);
                    if (!lca.isEmpty()) return lca.iterator().next();
                    return null;
                }
                if (!(value instanceof AbstractFloatBinopExpr)) return null;
                return tl instanceof PrimitiveType.IntType ? PrimitiveType.getInt() : tl;
            }
            if (!(value instanceof AbstractUnopExpr)) return value.getType();
            Type opt = this.evaluate(typing, (Value)((AbstractUnopExpr)value).getOp(), stmt, graph);
            if (!(value instanceof JLengthExpr)) return opt instanceof PrimitiveType.IntType ? PrimitiveType.getInt() : opt;
            return PrimitiveType.getInt();
        }
        if (!(value instanceof Ref)) return null;
        if (value instanceof JCaughtExceptionRef) {
            Set<ClassType> exceptionTypes = this.getExceptionTypeCandidates(stmt, graph);
            ClassType type = null;
            for (ClassType exceptionType : exceptionTypes) {
                Optional exceptionClassOpt = this.view.getClass(exceptionType);
                if (!exceptionClassOpt.isPresent()) {
                    return this.throwableClassType;
                }
                if (type == null) {
                    type = exceptionType;
                    continue;
                }
                type = this.getLeastCommonExceptionType(type, exceptionType);
            }
            return type;
        }
        if (value instanceof JArrayRef) {
            Type type = typing.getType(((JArrayRef)value).getBase());
            if (type instanceof ArrayType) {
                return ((ArrayType)type).getElementType();
            }
            if (!(type instanceof ClassType)) return BottomType.getInstance();
            return this.evalClassTypes.contains((Object)type) ? type : BottomType.getInstance();
        }
        if (value.getClass() != JThisRef.class && value.getClass() != JParameterRef.class && !(value instanceof JFieldRef)) return null;
        return value.getType();
    }

    private Set<ClassType> getExceptionTypeCandidates(@Nonnull Stmt handlerStmt, @Nonnull StmtGraph<?> graph) {
        return graph.getBlockOf(handlerStmt).getExceptionalPredecessors().keySet();
    }

    private Deque<ClassType> getExceptionPath(@Nonnull ClassType exceptionType) {
        ArrayDeque<ClassType> path = new ArrayDeque<ClassType>();
        path.push(exceptionType);
        while (exceptionType != this.throwableClassType) {
            Optional superclassOpt = this.view.getClass(exceptionType).flatMap(SootClass::getSuperclass);
            if (!superclassOpt.isPresent()) {
                throw new IllegalStateException("The path from '" + exceptionType + "' to java.lang.Throwable cannot be found!");
            }
            ClassType superType = (ClassType)superclassOpt.get();
            path.push(superType);
            exceptionType = superType;
        }
        return path;
    }

    private ClassType getLeastCommonExceptionType(@Nonnull ClassType a, @Nonnull ClassType b) {
        if (a == b) {
            return a;
        }
        ClassType commonType = null;
        Deque<ClassType> pathA = this.getExceptionPath(a);
        Deque<ClassType> pathB = this.getExceptionPath(b);
        while (!pathA.isEmpty() && !pathB.isEmpty() && pathA.peekFirst().equals((Object)pathB.peekFirst())) {
            commonType = pathA.removeFirst();
            pathB.removeFirst();
        }
        return commonType;
    }
}

