/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors.typeresolving;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractFloatBinopExpr;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JAndExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JInstanceOfExpr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JNeExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JOrExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.expr.JXorExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JEnterMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JExitMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.jimple.visitor.AbstractStmtVisitor;
import sootup.core.model.Body;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.java.bytecode.interceptors.typeresolving.AugEvalFunction;
import sootup.java.bytecode.interceptors.typeresolving.BytecodeHierarchy;
import sootup.java.bytecode.interceptors.typeresolving.StmtLocalPair;
import sootup.java.bytecode.interceptors.typeresolving.Typing;

public abstract class TypeChecker
extends AbstractStmtVisitor<Stmt> {
    private final AugEvalFunction evalFunction;
    private final BytecodeHierarchy hierarchy;
    private Typing typing;
    protected final Body.BodyBuilder builder;
    protected final MutableStmtGraph graph;
    private static final Logger logger = LoggerFactory.getLogger(TypeChecker.class);

    public TypeChecker(@Nonnull Body.BodyBuilder builder, @Nonnull AugEvalFunction evalFunction, @Nonnull BytecodeHierarchy hierarchy) {
        this.builder = builder;
        this.graph = builder.getStmtGraph();
        this.evalFunction = evalFunction;
        this.hierarchy = hierarchy;
    }

    public abstract void visit(@Nonnull Value var1, @Nonnull Type var2, @Nonnull Stmt var3);

    public void caseInvokeStmt(@Nonnull JInvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr(), (Stmt)stmt);
    }

    public void caseAssignStmt(@Nonnull JAssignStmt stmt) {
        Type type_rhs;
        Type type_base;
        LValue lhs = stmt.getLeftOp();
        Value rhs = stmt.getRightOp();
        Type type_lhs = null;
        if (lhs instanceof Local) {
            type_lhs = this.typing.getType((Local)lhs);
        } else if (lhs instanceof JArrayRef) {
            this.visit((Value)((JArrayRef)lhs).getIndex(), (Type)PrimitiveType.getInt(), (Stmt)stmt);
            ArrayType arrayType = null;
            Local base = ((JArrayRef)lhs).getBase();
            type_base = this.typing.getType(base);
            if (type_base instanceof ArrayType) {
                arrayType = (ArrayType)type_base;
            } else {
                if (rhs instanceof Local) {
                    type_rhs = this.typing.getType((Local)rhs);
                    if (type_base != null && (Type.isObjectLikeType((Type)type_base) || Type.isObject((Type)type_base) && type_rhs instanceof PrimitiveType)) {
                        Map defs = Body.collectDefs((Collection)this.graph.getNodes());
                        Collection defStmts = (Collection)defs.get(base);
                        boolean findDef = false;
                        if (defStmts != null) {
                            for (Stmt defStmt : defStmts) {
                                if (!(defStmt instanceof JAssignStmt)) continue;
                                Value arrExpr = ((JAssignStmt)defStmt).getRightOp();
                                if (arrExpr instanceof JNewArrayExpr) {
                                    arrayType = (ArrayType)arrExpr.getType();
                                    findDef = true;
                                    break;
                                }
                                if (!(arrExpr instanceof JNewMultiArrayExpr)) continue;
                                arrayType = ((JNewMultiArrayExpr)arrExpr).getBaseType();
                                findDef = true;
                                break;
                            }
                        }
                        if (!findDef && type_rhs != null) {
                            arrayType = Type.createArrayType((Type)type_rhs, (int)1);
                        }
                    }
                }
                if (arrayType == null && type_base != null) {
                    arrayType = Type.createArrayType((Type)type_base, (int)1);
                }
            }
            if (arrayType == null) {
                return;
            }
            type_lhs = arrayType.getElementType();
            this.visit((Value)base, (Type)arrayType, (Stmt)stmt);
            this.visit((Value)lhs, type_lhs, (Stmt)stmt);
        } else if (lhs instanceof JFieldRef) {
            if (lhs instanceof JInstanceFieldRef) {
                this.visit((Value)((JInstanceFieldRef)lhs).getBase(), (Type)((JInstanceFieldRef)lhs).getFieldSignature().getDeclClassType(), (Stmt)stmt);
            }
            type_lhs = lhs.getType();
        }
        if (rhs instanceof Local) {
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JArrayRef) {
            this.visit((Value)((JArrayRef)rhs).getIndex(), (Type)PrimitiveType.getInt(), (Stmt)stmt);
            Local base = ((JArrayRef)rhs).getBase();
            ArrayType arrayType = null;
            type_base = this.typing.getType(base);
            if (type_base instanceof ArrayType) {
                arrayType = (ArrayType)type_base;
            } else if (type_base instanceof NullType || Type.isObjectLikeType((Type)type_base)) {
                Map defs = Body.collectDefs((Collection)this.graph.getNodes());
                ArrayDeque<StmtLocalPair> worklist = new ArrayDeque<StmtLocalPair>();
                HashSet<StmtLocalPair> visited = new HashSet<StmtLocalPair>();
                worklist.add(new StmtLocalPair((Stmt)stmt, base));
                Type sel = null;
                while (!worklist.isEmpty()) {
                    StmtLocalPair pair = (StmtLocalPair)worklist.removeFirst();
                    if (!visited.add(pair)) continue;
                    Collection stmts = (Collection)defs.get(pair.getLocal());
                    for (Stmt s : stmts) {
                        if (!(s instanceof JAssignStmt)) continue;
                        Value value = ((JAssignStmt)s).getRightOp();
                        if (value instanceof JNewArrayExpr) {
                            sel = this.selectArrayType(sel, ((JNewArrayExpr)value).getBaseType(), s);
                            continue;
                        }
                        if (value instanceof JNewMultiArrayExpr) {
                            sel = this.selectArrayType(sel, (Type)((JNewMultiArrayExpr)value).getBaseType(), s);
                            continue;
                        }
                        if (value instanceof Local) {
                            worklist.add(new StmtLocalPair(s, (Local)value));
                            continue;
                        }
                        if (!(value instanceof JCastExpr)) continue;
                        worklist.add(new StmtLocalPair(s, (Local)((JCastExpr)value).getOp()));
                    }
                }
                if (sel == null) {
                    sel = type_base;
                }
                arrayType = Type.createArrayType((Type)sel, (int)1);
            }
            if (arrayType != null) {
                type_rhs = arrayType.getElementType();
                this.visit((Value)base, (Type)arrayType, (Stmt)stmt);
                this.visit(rhs, type_rhs, (Stmt)stmt);
                this.visit(rhs, type_lhs, (Stmt)stmt);
            }
        } else if (rhs instanceof JInstanceFieldRef) {
            this.visit((Value)((JInstanceFieldRef)rhs).getBase(), (Type)((JInstanceFieldRef)rhs).getFieldSignature().getDeclClassType(), (Stmt)stmt);
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof AbstractBinopExpr) {
            this.handleBinopExpr((AbstractBinopExpr)rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof AbstractInvokeExpr) {
            this.handleInvokeExpr((AbstractInvokeExpr)rhs, (Stmt)stmt);
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JCastExpr) {
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JInstanceOfExpr) {
            this.visit((Value)((JInstanceOfExpr)rhs).getOp(), (Type)this.hierarchy.objectClassType, (Stmt)stmt);
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JNewArrayExpr) {
            this.visit((Value)((JNewArrayExpr)rhs).getSize(), (Type)PrimitiveType.getInt(), (Stmt)stmt);
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JNewMultiArrayExpr) {
            for (int i = 0; i < ((JNewMultiArrayExpr)rhs).getSizeCount(); ++i) {
                this.visit(((JNewMultiArrayExpr)rhs).getSize(i), (Type)PrimitiveType.getInt(), (Stmt)stmt);
            }
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JLengthExpr) {
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JNegExpr) {
            this.visit((Value)((JNegExpr)rhs).getOp(), type_lhs, (Stmt)stmt);
        } else if (rhs instanceof JNewExpr) {
            this.visit(rhs, type_lhs, (Stmt)stmt);
        } else if (rhs instanceof Constant && !(rhs instanceof NullConstant)) {
            this.visit(rhs, type_lhs, (Stmt)stmt);
        }
    }

    public void caseEnterMonitorStmt(@Nonnull JEnterMonitorStmt stmt) {
        this.visit((Value)stmt.getOp(), (Type)this.hierarchy.objectClassType, (Stmt)stmt);
    }

    public void caseExitMonitorStmt(@Nonnull JExitMonitorStmt stmt) {
        this.visit((Value)stmt.getOp(), (Type)this.hierarchy.objectClassType, (Stmt)stmt);
    }

    public void caseIfStmt(@Nonnull JIfStmt stmt) {
        this.handleBinopExpr((AbstractBinopExpr)stmt.getCondition(), (Type)PrimitiveType.getBoolean(), (Stmt)stmt);
    }

    public void caseSwitchStmt(@Nonnull JSwitchStmt stmt) {
        this.visit((Value)stmt.getKey(), (Type)PrimitiveType.getInt(), (Stmt)stmt);
    }

    public void caseReturnStmt(@Nonnull JReturnStmt stmt) {
        this.visit((Value)stmt.getOp(), this.builder.getMethodSignature().getType(), (Stmt)stmt);
    }

    public void caseThrowStmt(@Nonnull JThrowStmt stmt) {
        this.visit((Value)stmt.getOp(), (Type)this.hierarchy.throwableClassType, (Stmt)stmt);
    }

    public AugEvalFunction getFuntion() {
        return this.evalFunction;
    }

    public BytecodeHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Typing getTyping() {
        return this.typing;
    }

    public void setTyping(Typing typing) {
        this.typing = typing;
    }

    private void handleInvokeExpr(AbstractInvokeExpr expr, Stmt stmt) {
        MethodSignature signature = expr.getMethodSignature();
        if (expr instanceof AbstractInstanceInvokeExpr) {
            this.visit((Value)((AbstractInstanceInvokeExpr)expr).getBase(), (Type)signature.getDeclClassType(), stmt);
        }
        for (int i = 0; i < expr.getArgCount(); ++i) {
            this.visit(expr.getArg(i), (Type)signature.getParameterTypes().get(i), stmt);
        }
    }

    private void handleBinopExpr(AbstractBinopExpr expr, Type type, Stmt stmt) {
        Immediate op1 = expr.getOp1();
        Immediate op2 = expr.getOp2();
        Type t1 = this.evalFunction.evaluate(this.typing, (Value)op1, stmt, (StmtGraph<?>)this.graph);
        Type t2 = this.evalFunction.evaluate(this.typing, (Value)op2, stmt, (StmtGraph<?>)this.graph);
        if (expr instanceof AbstractConditionExpr || expr instanceof AbstractFloatBinopExpr || expr instanceof JShlExpr || expr instanceof JShrExpr || expr instanceof JUshrExpr) {
            if (expr instanceof JEqExpr || expr instanceof JNeExpr) {
                if (!(t1 instanceof PrimitiveType.BooleanType && t2 instanceof PrimitiveType.BooleanType || !(t1 instanceof PrimitiveType.IntType))) {
                    this.visit((Value)op1, (Type)PrimitiveType.getInt(), stmt);
                    this.visit((Value)op2, (Type)PrimitiveType.getInt(), stmt);
                }
            } else if (type instanceof PrimitiveType.IntType) {
                this.visit((Value)op1, (Type)PrimitiveType.getInt(), stmt);
                this.visit((Value)op2, (Type)PrimitiveType.getInt(), stmt);
            }
        } else if (expr instanceof JXorExpr || expr instanceof JOrExpr || expr instanceof JAndExpr) {
            this.visit((Value)op1, type, stmt);
            this.visit((Value)op2, type, stmt);
        }
    }

    public Type selectArrayType(@Nullable Type preType, @Nonnull Type newType, @Nonnull Stmt stmt) {
        if (preType == null || preType.equals(newType)) {
            return newType;
        }
        Type sel = Type.getValueBitSize((Type)newType) > Type.getValueBitSize((Type)preType) ? newType : preType;
        logger.warn("Conflicting array types at " + stmt + " in " + this.builder.getMethodSignature() + ". Its base type may be " + preType + " or " + newType + ". Selecting: " + sel);
        return sel;
    }
}

