/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.plugin.java8.check.expression;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import javax.lang.model.element.Name;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;

public class LambdaAccessFinalInLoopCheck
implements CheckContributor<VariableTree> {
    private static boolean isLoop(TreePath path) {
        Tree tree = path.getLeaf();
        return tree instanceof ForLoopTree || tree instanceof EnhancedForLoopTree || tree instanceof WhileLoopTree;
    }

    private static boolean isMethodOrClassDeclaration(TreePath path) {
        Tree tree = path.getLeaf();
        return tree instanceof MethodTree || tree instanceof ClassTree;
    }

    private boolean isVariable(GenerationContext<Void> context) {
        if (context.getCurrentPath().getParentPath().getLeaf() instanceof ClassTree) {
            return false;
        }
        if (context.getCurrentPath().getParentPath().getLeaf() instanceof MethodTree) {
            return false;
        }
        return !(context.getCurrentPath().getParentPath().getLeaf() instanceof LambdaExpressionTree);
    }

    private void checkVarInLambda(final Name outsideVarName, LambdaExpressionTree lambda, final GenerationContext<Void> context) {
        lambda.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree ident, Void arg1) {
                if (ident.getName().equals(outsideVarName)) {
                    context.addError((Tree)ident, "To prevent unexpected behaviour in Javascript, final (or effectively final) variables must be declared at method level and not inside loops. Variable to be moved: " + ident.getName());
                }
                return (Void)super.visitIdentifier(ident, arg1);
            }
        }, null);
    }

    private void checkUsageInLambdas(final VariableTree tree, final GenerationContext<Void> context) {
        TreePath blockPath = context.getCurrentPath().getParentPath();
        blockPath.getLeaf().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree lambda, Void arg1) {
                LambdaAccessFinalInLoopCheck.this.checkVarInLambda(tree.getName(), lambda, (GenerationContext<Void>)context);
                return (Void)super.visitLambdaExpression(lambda, arg1);
            }
        }, null);
    }

    public Void visit(CheckVisitor visitor, VariableTree tree, GenerationContext<Void> context) {
        if (!this.isVariable(context)) {
            return null;
        }
        for (TreePath p = context.getCurrentPath(); p != null; p = p.getParentPath()) {
            if (LambdaAccessFinalInLoopCheck.isLoop(p)) {
                this.checkUsageInLambdas(tree, context);
                break;
            }
            if (LambdaAccessFinalInLoopCheck.isMethodOrClassDeclaration(p)) break;
        }
        return null;
    }
}

