/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.plugin.java8.writer.expression;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.TreeScanner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.expression.IdentifierAccessOuterScopeCheck;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.declaration.MethodWriter;
import org.stjs.generator.writer.expression.MethodInvocationWriter;

public class LambdaExpressionWriter<JS>
implements WriterContributor<LambdaExpressionTree, JS> {
    private boolean accessOuterScope(LambdaExpressionTree lambda) {
        final AtomicBoolean outerScopeAccess = new AtomicBoolean(false);
        lambda.accept(new TreeScanner<Void, Void>(){
            private boolean checkStopped;

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void arg1) {
                if (this.checkStopped) {
                    return (Void)super.visitIdentifier(tree, arg1);
                }
                Element fieldElement = TreeUtils.elementFromUse((ExpressionTree)tree);
                if (IdentifierAccessOuterScopeCheck.isRegularInstanceField((Element)fieldElement, (IdentifierTree)tree) || "this".equals(tree.getName().toString())) {
                    outerScopeAccess.set(true);
                }
                return (Void)super.visitIdentifier(tree, arg1);
            }

            @Override
            public Void visitClass(ClassTree arg0, Void arg1) {
                this.checkStopped = true;
                return (Void)super.visitClass(arg0, arg1);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void arg1) {
                if (this.checkStopped) {
                    return (Void)super.visitMethodInvocation(tree, arg1);
                }
                ExecutableElement methodElement = TreeUtils.elementFromUse((MethodInvocationTree)tree);
                if (JavaNodes.isStatic((Element)methodElement)) {
                    return (Void)super.visitMethodInvocation(tree, arg1);
                }
                String name = MethodInvocationWriter.buildMethodName((MethodInvocationTree)tree);
                if ("this".equals(name) || "super".equals(name)) {
                    return (Void)super.visitMethodInvocation(tree, arg1);
                }
                if (!(tree.getMethodSelect() instanceof IdentifierTree)) {
                    return (Void)super.visitMethodInvocation(tree, arg1);
                }
                outerScopeAccess.set(true);
                return (Void)super.visitMethodInvocation(tree, arg1);
            }
        }, null);
        return outerScopeAccess.get();
    }

    public JS visit(WriterVisitor<JS> visitor, LambdaExpressionTree tree, GenerationContext<JS> context) {
        List params = MethodWriter.getParams(tree.getParameters(), context);
        JavaScriptBuilder js = context.js();
        Object body = visitor.scan(tree.getBody(), context);
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            body = js.returnStatement(body);
        }
        if (!(tree.getBody() instanceof BlockTree)) {
            body = js.block(Collections.singleton(body));
        }
        Object lambdaFunc = js.function(null, (Iterable)params, body);
        int specialThisParamPos = MethodWriter.getTHISParamPos(tree.getParameters());
        if (this.accessOuterScope(tree) || specialThisParamPos >= 0) {
            Object target = js.keyword(Keyword.THIS);
            Object stjsBind = js.property(context.js().name((CharSequence)"stjs"), (CharSequence)"bind");
            if (specialThisParamPos < 0) {
                return (JS)js.functionCall(stjsBind, Arrays.asList(target, lambdaFunc));
            }
            return (JS)js.functionCall(stjsBind, Arrays.asList(target, lambdaFunc, js.number((Number)specialThisParamPos)));
        }
        return (JS)lambdaFunc;
    }
}

