/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.plugin.java8.writer.expression;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;

public class MemberReferenceWriter<JS>
implements WriterContributor<MemberReferenceTree, JS> {
    private List<JS> generateArguments(GenerationContext<JS> context, int n) {
        JavaScriptBuilder js = context.js();
        ArrayList<Object> args = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            args.add(js.elementGet(js.name((CharSequence)"arguments"), js.number((Number)i)));
        }
        return args;
    }

    private JS generateStaticRef(MemberReferenceTree tree, GenerationContext<JS> context, ExecutableElement methodElement) {
        JavaScriptBuilder js = context.js();
        Element type = methodElement.getEnclosingElement();
        Object typeName = js.name((CharSequence)context.getNames().getTypeName(context, type, DependencyType.STATIC));
        return (JS)js.property(typeName, (CharSequence)tree.getName());
    }

    private JS generateInstanceRef(MemberReferenceTree tree, GenerationContext<JS> context, ExecutableElement methodElement) {
        JavaScriptBuilder js = context.js();
        Element type = methodElement.getEnclosingElement();
        context.getNames().getTypeName(context, type, DependencyType.STATIC);
        Object stjsBind = context.js().property(context.js().name((CharSequence)"stjs"), (CharSequence)"bind");
        Object methodName = js.string(tree.getName().toString());
        return (JS)js.functionCall(stjsBind, Collections.singletonList(methodName));
    }

    private JS generateCapturingRef(WriterVisitor<JS> visitor, MemberReferenceTree tree, GenerationContext<JS> context, ExecutableElement methodElement) {
        JavaScriptBuilder js = context.js();
        Object target = visitor.scan((Tree)tree.getQualifierExpression(), context);
        Object methodName = js.string(tree.getName().toString());
        Object stjsBind = context.js().property(context.js().name((CharSequence)"stjs"), (CharSequence)"bind");
        return (JS)js.functionCall(stjsBind, Arrays.asList(target, methodName));
    }

    private JS generateConstructorRef(GenerationContext<JS> context, ExecutableElement methodElement) {
        JavaScriptBuilder js = context.js();
        Element type = methodElement.getEnclosingElement();
        Object typeName = js.name((CharSequence)context.getNames().getTypeName(context, type, DependencyType.STATIC));
        Object newExpr = context.js().newExpression(typeName, this.generateArguments(context, methodElement.getParameters().size()));
        return (JS)js.function(null, Collections.emptyList(), js.returnStatement(newExpr));
    }

    public JS visit(WriterVisitor<JS> visitor, MemberReferenceTree tree, GenerationContext<JS> context) {
        ExecutableElement methodElement = (ExecutableElement)context.getTrees().getElement(context.getCurrentPath());
        Element qualifierElement = context.getTrees().getElement(new TreePath(context.getCurrentPath(), tree.getQualifierExpression()));
        if (tree.getMode() == MemberReferenceTree.ReferenceMode.INVOKE) {
            if (qualifierElement.getKind() == ElementKind.CLASS || qualifierElement.getKind() == ElementKind.INTERFACE) {
                if (JavaNodes.isStatic((Element)methodElement)) {
                    return this.generateStaticRef(tree, context, methodElement);
                }
                return this.generateInstanceRef(tree, context, methodElement);
            }
            return this.generateCapturingRef(visitor, tree, context, methodElement);
        }
        return this.generateConstructorRef(context, methodElement);
    }
}

