/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.appium.common.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.Set;
import org.testobject.rest.api.appium.common.data.Test;
import org.testobject.rest.api.appium.common.data.TestReport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SuiteReport {
    private final Id id;
    private final Set<TestReport> testReports;

    @JsonCreator
    public SuiteReport(@JsonProperty(value="id") Id id, @JsonProperty(value="testReports") Set<TestReport> testReports) {
        this.id = id;
        this.testReports = testReports;
    }

    public Id getId() {
        return this.id;
    }

    public Optional<TestReport.Id> getTestReportId(Test test) {
        for (TestReport testReport : this.testReports) {
            if (!testReport.getTest().equals(test)) continue;
            return Optional.of(testReport.getId());
        }
        return Optional.empty();
    }

    public Optional<String> getTestDeviceId(Test test) {
        for (TestReport testReport : this.testReports) {
            if (!testReport.getTest().equals(test)) continue;
            return Optional.of(testReport.getTest().getDeviceId());
        }
        return Optional.empty();
    }

    public static class Id
    extends org.testobject.rest.api.appium.common.data.Id<Long> {
        public Id(Long value) {
            super(value);
        }
    }
}

