/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.testobject.rest.api.model.DeviceDescriptor;

public class DeviceDescriptorsResource {
    private final WebTarget target;

    public DeviceDescriptorsResource(WebTarget target) {
        this.target = target;
    }

    public List<String> getAvailableDeviceDescriptorIds() {
        return this.target.path("descriptors").path("availableDescriptors").request("application/json").get(new GenericType<List<String>>(){});
    }

    public List<DeviceDescriptor> getAvailableDeviceDescriptors() {
        List<DeviceDescriptor.DeviceContainer> deviceDescriptors = this.target.path("descriptors").request("application/json").get(new GenericType<List<DeviceDescriptor.DeviceContainer>>(){});
        return this.filterAvailable(deviceDescriptors);
    }

    private List<DeviceDescriptor> filterAvailable(List<DeviceDescriptor.DeviceContainer> descriptors) {
        List<String> availableDescriptorIds = this.getAvailableDeviceDescriptorIds();
        return descriptors.stream().filter(deviceContainer -> availableDescriptorIds.contains(deviceContainer.id)).map(deviceContainer -> new DeviceDescriptor((DeviceDescriptor.DeviceContainer)deviceContainer, true)).collect(Collectors.toList());
    }
}

