/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource.v2;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.testobject.api.InvalidUserInputServerException;

public class AppStorageResource {
    private final WebTarget target;

    public AppStorageResource(WebTarget target) {
        this.target = target;
    }

    public String uploadAppXcuiTest(String apiKey, File ipa) throws InvalidUserInputServerException {
        return this.uploadFile(apiKey, ipa, "XCUITEST");
    }

    public String uploadAppXcuiApp(String apiKey, File ipa) throws InvalidUserInputServerException {
        return this.uploadFile(apiKey, ipa, "NATIVE");
    }

    public String uploadAppAndroidTest(String apiKey, File apk) throws InvalidUserInputServerException {
        return this.uploadFile(apiKey, apk, "ANDROID_INSTRUMENTATION_TEST");
    }

    public String uploadAppAndroidApp(String apiKey, File apk) throws InvalidUserInputServerException {
        return this.uploadFile(apiKey, apk, "NATIVE");
    }

    private String uploadFile(String apiKey, File file, String type) throws InvalidUserInputServerException {
        String apiKeyHeader = "Basic " + Base64.getEncoder().encodeToString(("user:" + apiKey).getBytes());
        try {
            return this.target.path("storage").path("upload").request().header("Authorization", apiKeyHeader).header("App-Type", type).post(Entity.entity(Files.newInputStream(file.toPath(), new OpenOption[0]), "application/octet-stream"), String.class);
        }
        catch (BadRequestException e) {
            Response response = e.getResponse();
            String errorMessage = this.parseConventionalErrorMessage(response).orElseThrow(() -> new RuntimeException(e));
            throw new InvalidUserInputServerException(errorMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private Optional<String> parseConventionalErrorMessage(Response response) {
        try {
            Object responseBodyObj;
            HashMap responseBody = response.readEntity(HashMap.class);
            if (responseBody.containsKey("message") && (responseBodyObj = responseBody.get("message")) instanceof String) {
                String message = (String)responseBodyObj;
                return Optional.of(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }
}

