/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.logging.Logger;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Action;
import org.tinystruct.application.Actions;
import org.tinystruct.application.Context;
import org.tinystruct.application.Template;
import org.tinystruct.application.Variables;
import org.tinystruct.data.component.Builder;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Resource;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.template.DefaultTemplate;
import org.tinystruct.system.template.PlainText;
import org.tinystruct.system.template.variable.DataType;
import org.tinystruct.system.template.variable.StringVariable;
import org.tinystruct.system.template.variable.Variable;
import org.tinystruct.system.util.StringUtilities;

public abstract class AbstractApplication
implements Application {
    private static final Logger logger = Logger.getLogger(AbstractApplication.class.getName());
    private final Actions actions = Actions.getInstance();
    private final String name = this.getClass().getName();
    private final Map<String, Variable<?>> variables = Variables.getInstance();
    protected Context context;
    protected final Map<String, CommandLine> commandLines = new HashMap<String, CommandLine>();
    protected Configuration<String> config;
    private Locale locale;
    private String output;
    private boolean templateRequired = true;
    private String templatePath;

    public void setTemplateRequired(boolean templateRequired) {
        this.templateRequired = templateRequired;
    }

    @Override
    public boolean isTemplateRequired() {
        return this.templateRequired;
    }

    @Override
    public void init(Context context) {
        this.context = context;
        if (this.context.getAttribute("language") != null && !this.context.getAttribute("language").toString().equalsIgnoreCase(this.config.get("default.language"))) {
            this.config.set("language", this.context.getAttribute("language").toString());
        } else {
            this.config.set("language", this.config.get("default.language"));
        }
        this.setLocale(this.config.get("language"));
    }

    @Override
    public Actions actions() {
        return this.actions;
    }

    public void setAction(String path, Action action) {
        this.actions.set(action);
        if (path.indexOf("-") != 0) {
            this.setLink(path);
        }
    }

    @Override
    public void setAction(String path, String function) {
        this.actions.set(this, path, function);
        if (path.indexOf("-") != 0) {
            this.setLink(path);
        }
    }

    public void setAction(String path, String function, String method) {
        this.actions.set(this, path, function, method);
        if (path.indexOf("-") != 0) {
            this.setLink(path);
        }
    }

    public String getOutputText() {
        return this.output;
    }

    public void setOutputText(String buffer) {
        this.output = buffer;
    }

    @Override
    public void setTemplate(Template template) throws ApplicationException {
        this.output = template.parse();
    }

    @Override
    public Configuration<String> getConfiguration() {
        return this.config;
    }

    @Override
    public void setConfiguration(Configuration<String> config) {
        this.config = config;
        this.config.set("clsid", this.name);
        this.config.set("default.language", "zh_CN");
        this.config.set("language", this.config.get("default.language"));
        this.config.set("charset", "utf-8");
        this.config.set("default.base_url", "/?q=");
        this.init();
        this.setLocale(this.config.get("language"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object invoke(String path) throws ApplicationException {
        Action action;
        String method = null;
        if (this.context != null && this.context.getAttribute("METHOD") != null) {
            method = this.context.getAttribute("METHOD").toString();
        }
        if ((action = this.actions.getAction(path, method)) == null) {
            throw new ApplicationException("Action [" + path + "] has not been registered.");
        }
        if (this.context != null) {
            this.context.setAttribute("REQUEST_ACTION", path);
            action.setContext(this.context);
        }
        return action.execute();
    }

    @Override
    public Object invoke(String path, Object[] parameters) throws ApplicationException {
        Action action;
        String method = null;
        if (this.context != null && this.context.getAttribute("METHOD") != null) {
            method = this.context.getAttribute("METHOD").toString();
        }
        if ((action = this.actions.getAction(path, method)) == null) {
            throw new ApplicationException("Action " + path + " path does not registered.");
        }
        return action.execute(parameters);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setVariable(Variable<?> variable, boolean forcely) {
        String variableName = "{%" + variable.getName() + "%}";
        if (forcely || !this.variables.containsKey(variableName)) {
            if (variable.getType() == DataType.OBJECT) {
                Builder builder = new Builder();
                try {
                    builder.parse(variable.getValue().toString());
                    Set elements = builder.keySet();
                    for (String key : elements) {
                        this.variables.put("{%" + variable.getName() + "." + key + "%}", new StringVariable("{%" + variable.getName() + "." + key + "%}", (String)builder.get(key)));
                    }
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                }
            }
            this.variables.put(variableName, variable);
        }
    }

    public void setVariable(String name, String value) {
        this.setVariable(name, value, true);
    }

    public void setVariable(String name, String value, boolean forced) {
        if (value == null) {
            value = "";
        }
        StringVariable variable = new StringVariable(name, value);
        this.setVariable(variable, forced);
    }

    public Variable<?> getVariable(String variable) {
        return this.variables.get("{%" + variable + "%}");
    }

    public String setText(String fieldName) {
        String text = this.getProperty(fieldName);
        String key = "[%" + fieldName + "%]";
        this.variables.put(key, new StringVariable(key, text));
        return text;
    }

    public String setText(String fieldName, Object ... args) {
        String text = String.format(this.getProperty(fieldName), args);
        String key = "[%" + fieldName + "%]";
        this.variables.put(key, new StringVariable(key, text));
        return text;
    }

    private void setLink(String name) {
        String key = "[%LINK:" + name + "%]";
        if (!this.variables.containsKey(key)) {
            this.variables.put(key, new StringVariable(key, name));
        }
    }

    public String getLink(String variable) {
        String linkName = "[%LINK:" + variable + "%]";
        if (this.variables.get(linkName) != null) {
            String baseUrl = this.getContext() != null && this.getContext().getAttribute("HTTP_HOST") != null ? this.getContext().getAttribute("HTTP_HOST").toString() : this.config.get("default.base_url");
            return baseUrl + this.variables.get(linkName).getValue();
        }
        return "#";
    }

    public String getConfiguration(String propertyName) {
        return this.config.get(propertyName);
    }

    public String getProperty(String propertyName) {
        Resource resource = Resource.getInstance(this.locale);
        return resource.getLocaleString(propertyName);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(String locale) {
        String[] local = locale.split("_");
        this.setLocale(new Locale(local[0], local[1]));
        this.setVariable("language_code", local[0]);
        this.setVariable("language", this.locale.toString());
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setAction("--help", "help");
        if (this.commandLines.get("--help") != null) {
            this.commandLines.get("--help").setDescription("Help command");
        }
    }

    @Override
    public String toString() {
        if (!this.templateRequired) {
            return this.name + "@" + Integer.toHexString(this.hashCode());
        }
        InputStream in = null;
        String simpleName = this.getName().substring(this.getName().lastIndexOf(46) + 1);
        if (this.locale != Locale.CHINA) {
            this.templatePath = "themes" + File.separatorChar + simpleName + "_" + this.locale.toString() + ".view";
            in = AbstractApplication.class.getClassLoader().getResourceAsStream(this.templatePath);
        }
        if (null == in) {
            this.templatePath = "themes" + File.separatorChar + simpleName + ".view";
            in = AbstractApplication.class.getClassLoader().getResourceAsStream(this.templatePath);
        }
        if (null != in) {
            try {
                this.setTemplate(new DefaultTemplate((Application)this, in));
                return this.output;
            }
            catch (ApplicationException e) {
                throw new ApplicationRuntimeException(e.getMessage(), e);
            }
        }
        if (this.output != null && this.output.trim().length() > 0) {
            try {
                this.setTemplate(new PlainText((Application)this, this.output));
            }
            catch (ApplicationException e) {
                throw new ApplicationRuntimeException(e.getMessage(), e);
            }
            this.output = this.output.replace("[%", "").replace("%]", "");
            return this.output;
        }
        throw new ApplicationRuntimeException("The template " + this.templatePath + " could not be found and the output has not been set.");
    }

    @Override
    public CommandLine setCommandLine(CommandLine command) {
        return this.commandLines.put(command.getCommand(), command);
    }

    public void run() {
        throw new ApplicationRuntimeException("The method has not been implemented yet.");
    }

    @Override
    public String help() {
        StringBuilder builder = new StringBuilder("Usage: bin/dispatcher COMMAND [OPTIONS]\n");
        StringBuilder commands = new StringBuilder("Commands: \n");
        StringBuilder options = new StringBuilder("Options: \n");
        OptionalInt longSizeCommand = this.commandLines.keySet().stream().mapToInt(String::length).max();
        int max = longSizeCommand.orElse(0);
        this.commandLines.forEach((s, commandLine) -> {
            String command = commandLine.getCommand();
            String description = commandLine.getDescription();
            if (command.startsWith("--")) {
                options.append("\t").append(StringUtilities.rightPadding(command, max, ' ')).append("\t").append(description).append("\n");
            } else {
                commands.append("\t").append(StringUtilities.rightPadding(command, max, ' ')).append("\t").append(description).append("\n");
            }
        });
        builder.append((CharSequence)commands).append("\n");
        builder.append((CharSequence)options);
        return builder.toString();
    }

    @Override
    public Map<String, CommandLine> getCommandLines() {
        return this.commandLines;
    }
}

