/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Context;
import org.tinystruct.application.Method;

public class Action
implements Method<Object> {
    public static final int MAX_ARGUMENTS = 10;
    private final Pattern pattern;
    private final int id;
    private final Application app;
    private final java.lang.reflect.Method method;
    private final Logger logger = Logger.getLogger(Action.class.getName());
    private String pathRule;
    private Object[] args = new Object[0];

    public Action(int id, Application app, String pathRule, java.lang.reflect.Method method) {
        this.id = id;
        this.app = app;
        this.pathRule = pathRule;
        this.method = method;
        this.pattern = Pattern.compile(pathRule);
    }

    public int getId() {
        return this.id;
    }

    public String getApplicationName() {
        return this.app.getName();
    }

    public void setContext(Context context) {
        this.app.init(context);
    }

    public String getPathRule() {
        return this.pathRule;
    }

    public void setPathRule(String path) {
        this.pathRule = path;
    }

    @Override
    public Object execute(Object[] args) throws ApplicationException {
        Object[] arguments = new Object[]{};
        if (this.method != null) {
            Class<?>[] types = this.method.getParameterTypes();
            if (types.length > 0 && args.length == types.length) {
                arguments = this.getArguments(args, types);
            }
            if (this.method.getReturnType().isAssignableFrom(Void.TYPE)) {
                try {
                    this.method.invoke((Object)this.app, arguments);
                    if (!this.app.isTemplateRequired()) {
                        return null;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ApplicationException(this.method.toGenericString() + ":" + e.getMessage(), e);
                }
                return this.app.toString();
            }
            try {
                return this.method.invoke((Object)this.app, arguments);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ApplicationException(this.method.toGenericString() + ":" + e.getMessage(), e);
            }
        }
        this.logger.warning("Unsupported Operation.");
        throw new UnsupportedOperationException();
    }

    public Object execute() throws ApplicationException {
        if (this.app == null) {
            throw new ApplicationException("Undefined Application.");
        }
        if (this.app.getContext() != null && this.app.getContext().getAttribute("--help") != null) {
            return this.app.help();
        }
        return this.execute(this.args);
    }

    private Object[] getArguments(Object[] args, Class<?>[] types) {
        if (args.length > 0 && types.length > 0) {
            Object[] arguments = new Object[types.length];
            for (int n = 0; n < types.length; ++n) {
                if (types[n].isAssignableFrom(Date.class)) {
                    try {
                        arguments[n] = new SimpleDateFormat("yyyy-MM-dd").parse(String.valueOf(args[n]));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ApplicationRuntimeException(e.getMessage(), e);
                    }
                }
                arguments[n] = types[n].isAssignableFrom(Integer.TYPE) ? Integer.valueOf(String.valueOf(args[n])) : (types[n].isAssignableFrom(Long.TYPE) ? Long.valueOf(String.valueOf(args[n])) : (types[n].isAssignableFrom(Float.TYPE) ? Float.valueOf(String.valueOf(args[n])) : (types[n].isAssignableFrom(Double.TYPE) ? Double.valueOf(String.valueOf(args[n])) : (types[n].isAssignableFrom(Short.TYPE) ? Short.valueOf(String.valueOf(args[n])) : (types[n].isAssignableFrom(Byte.TYPE) ? Byte.valueOf(String.valueOf(args[n])) : (types[n].isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(String.valueOf(args[n])) : args[n]))))));
            }
            return arguments;
        }
        return args;
    }

    public void setArguments(Object[] args) {
        this.args = args;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

