/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.tinystruct.Application;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Action;
import org.tinystruct.system.cli.CommandArgument;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.util.StringUtilities;

public final class Actions {
    private static final Map<String, Action> map = new ConcurrentHashMap<String, Action>(16);
    private static final Map<String, CommandLine> commands = new ConcurrentHashMap<String, CommandLine>(16);

    private Actions() {
    }

    public static Actions getInstance() {
        return SingletonHolder.actions;
    }

    public void set(Application app, String path, String methodName) {
        if (path == null) {
            return;
        }
        this.initializePatterns(app, path, methodName);
    }

    public void set(Application app, String path, String methodName, String method) {
        this.set(app, path, methodName);
    }

    public void set(Action action) {
        if (action == null) {
            return;
        }
        map.put(action.getPathRule(), action);
    }

    public Action get(String path) {
        Set<Map.Entry<String, Action>> set = map.entrySet();
        for (Map.Entry<String, Action> n : set) {
            Action action = n.getValue();
            Matcher matcher = action.getPattern().matcher(path);
            if (!matcher.find()) continue;
            Object[] args = new Object[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                args[i] = matcher.group(i + 1);
            }
            action.setArguments(args);
            return action;
        }
        return null;
    }

    public boolean remove(String path) {
        return null != map.remove(path);
    }

    public Collection<Action> list() {
        return map.values();
    }

    public Action getAction(String path) {
        Action action = this.get(path);
        if (action != null || (action = this.get(new StringUtilities(path).removeTrailingSlash())) != null) {
            return action;
        }
        return null;
    }

    public CommandLine getCommand(String path) {
        return commands.get(path);
    }

    public Action getAction(String path, String method) {
        return this.getAction(path);
    }

    private void initializePatterns(Application app, String path, String methodName) {
        Class<?> clazz = app.getClass();
        Method[] functions = new Method[10];
        int n = 0;
        try {
            Method[] methods;
            for (Method value : methods = clazz.getMethods()) {
                if (!value.getName().equals(methodName)) continue;
                functions[n++] = value;
            }
        }
        catch (SecurityException e) {
            throw new ApplicationRuntimeException("[" + methodName + "]" + e.getMessage(), e);
        }
        CommandLine cli = new CommandLine(app, path, "");
        commands.put(path, cli);
        String patternPrefix = "/?" + path;
        for (int j = 0; j < n; ++j) {
            String expression;
            Method m = functions[j];
            if (null == m) continue;
            Class<?>[] types = m.getParameterTypes();
            Parameter[] params = m.getParameters();
            if (types.length > 0) {
                StringBuilder patterns = new StringBuilder();
                for (int i = types.length - 1; i >= 0; --i) {
                    cli.addArgument(new CommandArgument<String, Object>(params[i].getName(), null, ""));
                    Object pattern = "(";
                    pattern = types[i].isAssignableFrom(Integer.TYPE) ? (String)pattern + "-?\\d+" : (types[i].isAssignableFrom(Long.TYPE) ? (String)pattern + "-?\\d+" : (types[i].isAssignableFrom(Float.TYPE) ? (String)pattern + "-?\\d+(\\.\\d+)" : (types[i].isAssignableFrom(Double.TYPE) ? (String)pattern + "-?\\d+(\\.\\d+)" : (types[i].isAssignableFrom(Short.TYPE) ? (String)pattern + "-?\\d+" : (types[i].isAssignableFrom(Byte.TYPE) ? (String)pattern + "\\d+" : (types[i].isAssignableFrom(Boolean.TYPE) ? (String)pattern + "true|false" : (String)pattern + ".*"))))));
                    pattern = (String)pattern + ")";
                    if (patterns.length() != 0) {
                        patterns.append("/");
                    }
                    patterns.append((String)pattern);
                }
                expression = patternPrefix + "/" + patterns + "$";
            } else {
                expression = patternPrefix + "$";
            }
            map.put(expression, new Action(map.size(), app, expression, m));
        }
        app.setCommandLine(cli);
    }

    private static final class SingletonHolder {
        static final Actions actions = new Actions();

        private SingletonHolder() {
        }
    }
}

