/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public final class Mutex {
    private static final AtomicInteger resources = new AtomicInteger(0);
    private final Synchronizer synchronizer = new Synchronizer(1);

    private Mutex() {
    }

    public static int get() {
        return resources.decrementAndGet();
    }

    public static int put() {
        return resources.addAndGet(1);
    }

    public void lock() {
        this.synchronizer.acquire(1);
    }

    public void unlock() {
        this.synchronizer.release(1);
    }

    static class Synchronizer
    extends AbstractQueuedSynchronizer {
        public Synchronizer(int state) {
            super.setState(state);
        }

        @Override
        protected boolean tryAcquire(int arg) {
            return super.compareAndSetState(arg, 0);
        }

        @Override
        protected boolean tryRelease(int arg) {
            super.setState(arg);
            return true;
        }
    }
}

