/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.Repository;
import org.tinystruct.system.Settings;

final class ConnectionManager
implements Runnable {
    private static final Logger logger = Logger.getLogger(ConnectionManager.class.getName());
    private final ConcurrentLinkedQueue<Connection> connections = new ConcurrentLinkedQueue();
    private final String driverName;
    private final String url;
    private final String user;
    private final String password;
    private final int max;
    private String database;
    private Boolean pending;

    private ConnectionManager() {
        Settings config = new Settings();
        this.driverName = (String)config.get("driver");
        try {
            assert (this.driverName != null);
            Driver driver = (Driver)Class.forName(this.driverName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(driver);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.database = (String)config.get("database");
        String dbUrl = (String)config.get("database.url");
        String dbUser = (String)config.get("database.user");
        String dbPassword = (String)config.get("database.password");
        String dbType = this.getConfiguredType().name().toLowerCase();
        if (null != dbUrl && !dbType.equalsIgnoreCase("h2")) {
            try {
                URI dbUri = dbUrl.startsWith("jdbc:" + dbType + "://") ? new URI(dbUrl.substring("jdbc:".length())) : (!dbUrl.startsWith(dbType + "://") ? new URI(dbType + "://" + dbUrl) : new URI(dbUrl));
                if (dbUri.getUserInfo() != null) {
                    dbUser = dbUri.getUserInfo().split(":")[0];
                    dbPassword = dbUri.getUserInfo().split(":")[1];
                }
                StringBuilder builder = new StringBuilder();
                builder.append("jdbc:" + dbType + "://");
                builder.append(dbUri.getHost());
                builder.append(":");
                if (dbUri.getPort() != -1) {
                    builder.append(dbUri.getPort());
                } else {
                    builder.append(3306);
                }
                if (dbUri.getPath() != null) {
                    builder.append(dbUri.getPath().replaceAll("//", "/"));
                }
                if (dbUri.getQuery() != null) {
                    builder.append("?");
                    builder.append(dbUri.getQuery());
                }
                dbUrl = builder.toString();
            }
            catch (URISyntaxException e) {
                logger.severe(e.getMessage());
            }
        }
        this.url = dbUrl;
        this.user = dbUser;
        this.password = dbPassword;
        this.max = ((String)config.get("database.connections.max")).trim().length() > 0 ? Integer.parseInt((String)config.get("database.connections.max")) : 0;
        this.pending = false;
    }

    public static ConnectionManager getInstance() {
        return SingletonHolder.manager;
    }

    public Repository.Type getConfiguredType() {
        int index = -1;
        int length = Repository.Type.values().length;
        for (int i = 0; i < length; ++i) {
            if (this.driverName.indexOf(Repository.Type.values()[i].name().toLowerCase()) == -1) continue;
            index = i;
            break;
        }
        switch (index) {
            case 0: {
                return Repository.Type.MySQL;
            }
            case 1: {
                return Repository.Type.SQLServer;
            }
            case 2: {
                return Repository.Type.SQLite;
            }
            case 3: {
                return Repository.Type.H2;
            }
        }
        return Repository.Type.MySQL;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Connection connection) {
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            this.connections.add(connection);
            if (this.connections.size() > this.max && !this.pending.booleanValue()) {
                this.pending = true;
                logger.severe("the current connection size(" + this.connections.size() + ") is out of the max number.");
                new Thread(this).start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws ApplicationException {
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            Connection connection;
            if (!this.connections.isEmpty()) {
                connection = this.connections.poll();
                try {
                    if (connection.isClosed()) {
                        logger.severe("\u53d1\u73b0\u4e86\u65e0\u6548\u8fde\u63a5\uff0c\u7cfb\u7edf\u5df2\u628a\u5b83\u5220\u9664\u6389\u4e86\uff01");
                        connection = this.getConnection();
                    }
                }
                catch (SQLException ex) {
                    logger.log(Level.WARNING, "\u83b7\u53d6\u8fde\u63a5\u51fa\u9519\uff01\u4fe1\u606f\uff1a" + ex.getMessage(), ex);
                    connection = this.getConnection();
                }
            } else {
                try {
                    connection = null == this.user || this.user.trim().length() == 0 ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.user, this.password);
                    logger.log(Level.INFO, "System default database: " + connection.getCatalog());
                    if (this.database.trim().length() > 0) {
                        connection.setCatalog(this.database);
                    }
                }
                catch (SQLException ex) {
                    throw new ApplicationException(ex.getMessage(), ex);
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return connection;
        }
    }

    public int size() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            while (true) {
                if (this.connections.isEmpty()) {
                    this.pending = false;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return;
                }
                Connection current = this.connections.poll();
                if (current == null) continue;
                try {
                    if (current.isClosed()) continue;
                    current.close();
                }
                catch (SQLException ex) {
                    logger.log(Level.WARNING, "\u5173\u95ed\u8fde\u63a5\u51fa\u9519\uff01\u4fe1\u606f\uff1a" + ex.getMessage(), ex);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            while (!this.connections.isEmpty()) {
                Connection current = this.connections.poll();
                if (current == null) continue;
                try {
                    if (current.isClosed()) continue;
                    current.close();
                }
                catch (SQLException ex) {
                    logger.log(Level.WARNING, "\u5173\u95ed\u8fde\u63a5\u51fa\u9519\uff01\u4fe1\u606f\uff1a" + ex.getMessage(), ex);
                }
            }
            return;
        }
    }

    private static final class SingletonHolder {
        static final ConnectionManager manager = new ConnectionManager();

        private SingletonHolder() {
        }
    }
}

