/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.Data;
import org.tinystruct.data.MappingManager;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.dom.Attribute;
import org.tinystruct.dom.Document;
import org.tinystruct.dom.Element;

public class Mapping {
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String LENGTH = "length";
    private static final String COLUMN = "column";
    private static final String TYPE = "type";
    private static final String GENERATE = "generate";
    private static final String INCREMENT = "increment";
    private static final String ID = "id";
    private final Field fields = new Field();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field getMappedField(Data data) throws ApplicationException {
        String className = data.getClassName();
        String mapFile = data.getClassPath() + className + ".map.xml";
        MappingManager manager = MappingManager.getInstance();
        Class<Mapping> clazz = Mapping.class;
        synchronized (Mapping.class) {
            Document document;
            if (manager.get(className) == null) {
                document = new Document();
                InputStream in = data.getClass().getResourceAsStream("/" + mapFile);
                boolean loaded = document.load(in);
                if (!loaded) {
                    System.out.println(mapFile);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return null;
                }
                manager.set(className, document);
            } else {
                document = manager.get(className);
            }
            List<Element> list = null;
            Iterator<Element> iterator = document.getRoot().getElementsByTagName("class").iterator();
            Element currentElement2 = null;
            while (iterator.hasNext()) {
                currentElement2 = iterator.next();
                if (!className.equalsIgnoreCase(currentElement2.getAttribute(NAME))) continue;
                switch (data.getRepository().getType().ordinal()) {
                    case 0: {
                        data.setTableName("`" + currentElement2.getAttribute("table") + "`");
                        break;
                    }
                    case 1: {
                        data.setTableName("[" + currentElement2.getAttribute("table") + "]");
                        break;
                    }
                    default: {
                        data.setTableName("`" + currentElement2.getAttribute("table") + "`");
                    }
                }
                list = currentElement2.getChildNodes();
                break;
            }
            if (list != null && list.size() > 0) {
                for (Element currentElement2 : list) {
                    FieldInfo field;
                    if (currentElement2.getName().equalsIgnoreCase(ID)) {
                        field = new FieldInfo();
                        field.append(ID, currentElement2.getAttribute(NAME));
                        field.append(NAME, currentElement2.getAttribute(NAME));
                        field.append(INCREMENT, currentElement2.getAttribute(INCREMENT));
                        field.append(GENERATE, currentElement2.getAttribute(GENERATE));
                        field.append(TYPE, currentElement2.getAttribute(TYPE));
                        field.append(COLUMN, currentElement2.getAttribute(COLUMN));
                        field.append(LENGTH, currentElement2.getAttribute(LENGTH));
                        if (Boolean.parseBoolean(currentElement2.getAttribute(GENERATE))) {
                            data.setId(UUID.randomUUID().toString());
                            field.append("value", data.getId());
                        }
                        this.fields.append(field.getName(), field);
                    }
                    if (!currentElement2.getName().equalsIgnoreCase(PROPERTY)) continue;
                    field = new FieldInfo();
                    List<Attribute> attributes = currentElement2.getAttributes();
                    Iterator<Attribute> iterator2 = attributes.iterator();
                    while (iterator2.hasNext()) {
                        Attribute attribute;
                        Attribute currentAttribute = attribute = iterator2.next();
                        field.append(currentAttribute.name, currentAttribute.value);
                    }
                    this.fields.append(field.getName(), field);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return this.fields;
        }
    }
}

