/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.data.Data;
import org.tinystruct.data.Mapping;
import org.tinystruct.data.Repository;
import org.tinystruct.data.component.Condition;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.H2Server;
import org.tinystruct.data.component.MySQLServer;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.SQLServer;
import org.tinystruct.data.component.SQLiteServer;
import org.tinystruct.data.component.Table;
import org.tinystruct.system.Settings;
import org.tinystruct.system.util.ClassInfo;

public abstract class AbstractData
implements Data {
    private static final Logger logger = Logger.getLogger(AbstractData.class.getName());
    private String classPath;
    private String className = this.getClass().getSimpleName();
    protected Object Id;
    private String table;
    private Field readyFields;
    private Condition condition;
    private static Repository repository;

    protected AbstractData() {
        try {
            this.classPath = new ClassInfo(this).getClassPath();
        }
        catch (ApplicationException e) {
            logger.severe(e.getMessage());
        }
        this.readyFields = new Field();
        try {
            this.readyFields = new Mapping().getMappedField(this);
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static Repository getDefaultServer() throws ApplicationException {
        Repository repository;
        Settings properties = new Settings("/application.properties");
        String driver = (String)properties.get("driver");
        if (driver.trim().length() == 0) {
            throw new ApplicationRuntimeException("Database Connection Driver has not been set in application.properties!");
        }
        int index = -1;
        int length = Repository.Type.values().length;
        for (int i = 0; i < length; ++i) {
            if (driver.indexOf(Repository.Type.values()[i].name().toLowerCase()) == -1) continue;
            index = i;
            break;
        }
        switch (index) {
            case 1: {
                repository = new SQLServer();
                break;
            }
            case 2: {
                repository = new SQLiteServer();
                break;
            }
            case 3: {
                repository = new H2Server();
                break;
            }
            default: {
                repository = new MySQLServer();
            }
        }
        return repository;
    }

    @Override
    public String getClassPath() {
        return this.classPath;
    }

    @Override
    public Object setId(Object id) {
        this.Id = id;
        if (this.readyFields.containsKey("Id")) {
            this.readyFields.get("Id").set("value", this.Id);
        }
        return this.Id;
    }

    protected Object setField(String fieldName, Object fieldValue) {
        if (this.readyFields.containsKey(fieldName)) {
            this.readyFields.get(fieldName).set("value", fieldValue);
            return fieldValue;
        }
        return null;
    }

    protected Timestamp setFieldAsTimestamp(String fieldName, Timestamp fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return fieldValue;
        }
        return Timestamp.valueOf("2009-03-20");
    }

    protected Date setFieldAsDate(String fieldName, Date fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return fieldValue;
        }
        return new Date();
    }

    protected LocalDateTime setFieldAsLocalDateTime(String fieldName, LocalDateTime fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return fieldValue;
        }
        return LocalDateTime.now();
    }

    protected int setFieldAsInt(String fieldName, int fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return Integer.parseInt(t.toString());
        }
        return -1;
    }

    protected String setFieldAsString(String fieldName, String fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return t.toString();
        }
        return null;
    }

    protected boolean setFieldAsBoolean(String fieldName, boolean fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return Boolean.parseBoolean(t.toString());
        }
        return false;
    }

    @Override
    public boolean append() throws ApplicationException {
        return repository.append(this.readyFields, this.table);
    }

    @Override
    public boolean update() throws ApplicationException {
        return repository.update(this.readyFields, this.table);
    }

    @Override
    public boolean delete() throws ApplicationException {
        return repository.delete(this.Id, this.table);
    }

    protected int countAll(String SQL) {
        return 0;
    }

    @Override
    public Data setRequestFields(String fields) {
        this.condition = new Condition();
        this.condition.setRequestFields(fields);
        return this;
    }

    @Override
    public Data orderBy(String[] fieldNames) {
        StringBuilder orders = new StringBuilder();
        for (String fields : fieldNames) {
            if (orders.length() > 0) {
                orders.append(",").append(fields);
                continue;
            }
            orders.append(fields);
        }
        if (this.condition == null) {
            this.condition = new Condition();
        }
        this.condition.orderBy(orders.toString());
        return this;
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        return repository.find(SQL, parameters);
    }

    @Override
    public Table find(Condition condition, Object[] parameters) throws ApplicationException {
        return this.find(condition.toString(), parameters);
    }

    @Override
    public Table findWith(String where, Object[] parameters) throws ApplicationException {
        if (this.condition == null) {
            return this.find(new Condition().select(this.table).with(where), parameters);
        }
        return this.find(this.condition.select(this.table).with(where), parameters);
    }

    @Override
    public Row findOne(String SQL, Object[] parameters) throws ApplicationException {
        return repository.findOne(SQL, parameters);
    }

    @Override
    public Row findOneById() throws ApplicationException {
        Row row = this.findOne(new Condition().select(this.table).and("id=?").toString(), new Object[]{this.Id});
        if (row.size() > 0) {
            this.setData(row);
        }
        return row;
    }

    @Override
    public Row findOneByKey(String PK, String value) throws ApplicationException {
        Row row = this.findOne(new Condition().select(this.table).and(PK + "=?").toString(), new Object[]{value});
        if (row.size() > 0) {
            this.setData(row);
        }
        return row;
    }

    @Override
    public Table findAll() throws ApplicationException {
        if (this.condition == null) {
            return this.find(new Condition().select(this.table), new Object[0]);
        }
        return this.find(this.condition.select(this.table), new Object[0]);
    }

    public abstract void setData(Row var1);

    public abstract String toString();

    protected void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Object getId() {
        return this.Id;
    }

    public String getTableName() {
        return this.table;
    }

    @Override
    public void setTableName(String table) {
        this.table = table;
    }

    @Override
    public Repository getRepository() {
        return repository;
    }

    static {
        try {
            repository = AbstractData.getDefaultServer();
        }
        catch (ApplicationException e) {
            logger.severe(e.getMessage());
        }
    }
}

