/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.component.Builders;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Struct;
import org.tinystruct.system.util.StringUtilities;

public class Builder
extends HashMap<String, Object>
implements Struct,
Serializable {
    private static final long serialVersionUID = 3484789992424316230L;
    private static final String QUOTE = "\"";
    private static final Logger logger = Logger.getLogger(Builder.class.getName());
    private int closedPosition = 0;

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set keys = this.keySet();
        for (String key : keys) {
            Object value = this.get(key);
            if (value instanceof String || value instanceof StringBuffer || value instanceof StringBuilder) {
                buffer.append(QUOTE).append(key).append(QUOTE).append(":").append(QUOTE).append(StringUtilities.escape(value.toString())).append(QUOTE);
            } else {
                buffer.append(QUOTE).append(key).append(QUOTE).append(":").append(value);
            }
            buffer.append(",");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return "{" + buffer + "}";
    }

    @Override
    public void parse(String resource) throws ApplicationException {
        if (!(resource = resource.trim()).startsWith("{") && !resource.endsWith("}")) {
            throw new ApplicationException("Invalid data format!");
        }
        if (resource.startsWith("{")) {
            logger.log(Level.FINE, "\u5f85\u5904\u7406:{}", resource);
            this.closedPosition = this.seekPosition(resource);
            String values = resource.substring(1, this.closedPosition - 1);
            logger.log(Level.FINE, "\u5df2\u8131\u58f3:{}", values);
            this.parseValue(values);
        }
    }

    public int getClosedPosition() {
        return this.closedPosition;
    }

    public void setClosedPosition(int closedPosition) {
        this.closedPosition = closedPosition;
    }

    private void parseValue(String value) throws ApplicationException {
        logger.log(Level.FINE, "\u5f85\u5206\u6790:{}", value);
        value = value.trim();
        if (value.startsWith(QUOTE)) {
            Object keyValue;
            int COLON_POSITION = value.indexOf(58);
            int start = COLON_POSITION + 1;
            String keyName = value.substring(1, COLON_POSITION - 1);
            logger.log(Level.FINE, "\u53d6\u952e\u503c:{}", keyName);
            String $value = value.substring(start).trim();
            logger.log(Level.FINE, "\u5206\u6790\u503c:{}", $value);
            if ($value.startsWith(QUOTE)) {
                logger.log(Level.FINE, "\u63d0\u53d6\u503c:{}", $value);
                int $end = this.next($value, '\"');
                keyValue = $value.substring(1, $end - 1).trim();
                if ($end + 1 < $value.length()) {
                    $value = $value.substring($end + ",".length());
                    this.parseValue($value);
                }
            } else if ($value.indexOf(123) == 0) {
                logger.log(Level.FINE, "\u9047\u5b9e\u4f53:{}", $value);
                int closedPosition = this.seekPosition($value);
                String _$value = $value.substring(0, closedPosition);
                logger.log(Level.FINE, "\u5206\u5b9e\u4f53:{}", _$value);
                Builder builder = new Builder();
                builder.parse(_$value);
                keyValue = builder;
                if (closedPosition < $value.length()) {
                    _$value = $value.substring(closedPosition + ",".length());
                    logger.log(Level.FINE, "\u5206\u5b9e\u4f53:{}", _$value);
                    this.parseValue(_$value);
                }
            } else if ($value.indexOf(91) == 0) {
                Builders builders = new Builders();
                logger.log(Level.FINE, $value);
                builders.parse($value);
                keyValue = builders;
            } else if ($value.indexOf(44) != -1) {
                keyValue = $value.substring(0, $value.indexOf(44));
                $value = $value.substring($value.indexOf(44) + 1);
                this.parseValue($value);
            } else {
                keyValue = $value;
            }
            this.put(keyName, keyValue);
        }
    }

    private int seekPosition(String value) {
        char[] chars = value.toCharArray();
        int n = 0;
        int position = chars.length;
        for (int i = 0; i < position; ++i) {
            char c = chars[i];
            if (c == '{') {
                if (i - 1 >= 0 && chars[i - 1] == '\\') continue;
                ++n;
                continue;
            }
            if (c != '}' || i - 1 >= 0 && chars[i - 1] == '\\') continue;
            --n;
            if (n != 0) continue;
            position = i;
        }
        return position;
    }

    private int next(String value, char begin) {
        char[] chars = value.toCharArray();
        int n = 0;
        int position = chars.length;
        for (int i = 0; i < position; ++i) {
            char c = chars[i];
            if (c != begin || i - 1 >= 0 && chars[i - 1] == '\\') continue;
            ++n;
            if (n != 2) continue;
            position = i;
        }
        return position;
    }

    @Override
    public Row toData() {
        Row row = new Row();
        Field field = new Field();
        Set keySet = this.keySet();
        for (String key : keySet) {
            Object value = this.get(key);
            FieldInfo info = new FieldInfo();
            info.set("name", key);
            info.set("value", value);
            field.append(key, info);
        }
        row.append(field);
        return row;
    }

    public void saveAsFile(File file) throws ApplicationException {
        try (PrintWriter writer = new PrintWriter(file);){
            writer.write(this.toString());
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    @Override
    public int size() {
        return this.keySet().size();
    }
}

