/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.component.Builder;

public class Builders
extends ArrayList<Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Builders.class.getName());

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Object o : this) {
            buffer.append(o);
            buffer.append(',');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return "[" + buffer + "]";
    }

    public void parse(String value) throws ApplicationException {
        if (value.indexOf("{") == 0) {
            logger.log(Level.FINE, "\u5206\u6790\u5b9e\u4f53\uff1a{}", value);
            Builder builder = new Builder();
            builder.parse(value);
            this.add(builder);
            int p = builder.getClosedPosition();
            if (p < value.length() && value.charAt(p) == ',') {
                value = value.substring(p + 1);
                this.parse(value);
            }
        }
        if (value.indexOf(91) == 0) {
            logger.log(Level.FINE, "\u5206\u6790\u4f53\u7ec4\uff1a{}", value);
            int end = this.seekPosition(value);
            logger.log(Level.FINE, "\u7ed3\u675f\u4f4d: {}" + end + " \u957f\u5ea6:{}" + value.length());
            this.parse(value.substring(1, end - 1));
            int len = value.length();
            if (end < len - 1) {
                this.parse(value.substring(end + 1));
            }
        }
    }

    private int seekPosition(String value) {
        char[] chars = value.toCharArray();
        int i = 0;
        int n = 0;
        int position = chars.length;
        while (i < position) {
            char c;
            if ((c = chars[i++]) == '[') {
                ++n;
            } else if (c == ']') {
                --n;
            }
            if (n != 0) continue;
            position = i;
        }
        return position;
    }
}

