/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.data.Cacheable;

public final class Cache
implements Cacheable {
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();

    private Cache() {
    }

    public static Cache getInstance() {
        return SingletonHolder.cache;
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public void set(String key, Object value) {
        if (key != null && value != null) {
            this.map.put(key, value);
        }
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    private static final class SingletonHolder {
        static final Cache cache = new Cache();

        private SingletonHolder() {
        }
    }
}

